/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.http.client;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class RefFileByteSource
extends ByteSource {
    private final File file;
    private final ByteSource byteSource;

    public RefFileByteSource(File file) {
        this.file = file;
        this.byteSource = Files.asByteSource((File)file);
    }

    File getFile() {
        return this.file;
    }

    public byte[] read() throws IOException {
        return this.byteSource.read();
    }

    public long size() throws IOException {
        return this.byteSource.size();
    }

    public InputStream openStream() throws IOException {
        return this.byteSource.openStream();
    }

    protected void finalize() throws Throwable {
        try {
            this.file.delete();
        }
        finally {
            super.finalize();
        }
    }
}

