/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.http.client;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import okhttp3.OkHttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;

final class CertificateTools {
    private final ByteSource certificates;
    private final ByteSource clientCertificate;

    public CertificateTools(ByteSource certificates, ByteSource clientCertificate) {
        this.certificates = certificates;
        this.clientCertificate = clientCertificate;
    }

    public void setupHandshakeCertificates(OkHttpClient.Builder clientBuilder) throws IOException {
        if (this.certificates != null || this.clientCertificate != null) {
            HandshakeCertificates.Builder handshakeCertificatesBuilder;
            block11: {
                handshakeCertificatesBuilder = new HandshakeCertificates.Builder();
                if (this.certificates != null) {
                    try (InputStream certificatesStream = this.certificates.openStream();){
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        certificateFactory.generateCertificates(certificatesStream).stream().map(certificate -> (X509Certificate)certificate).forEach(arg_0 -> ((HandshakeCertificates.Builder)handshakeCertificatesBuilder).addTrustedCertificate(arg_0));
                        break block11;
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                }
                handshakeCertificatesBuilder.addPlatformTrustedCertificates();
            }
            if (this.clientCertificate != null) {
                handshakeCertificatesBuilder.heldCertificate(HeldCertificate.decode((String)new String(this.clientCertificate.read(), StandardCharsets.ISO_8859_1)), new X509Certificate[0]);
            }
            HandshakeCertificates handshakeCertificates = handshakeCertificatesBuilder.build();
            clientBuilder.sslSocketFactory(handshakeCertificates.sslSocketFactory(), handshakeCertificates.trustManager());
        }
    }
}

