/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.http.client;

import com.enonic.lib.http.client.CookieJar;
import com.enonic.lib.http.client.HttpRequestHandler;
import com.enonic.lib.http.client.RefFileByteSource;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public final class ResponseMapper
implements MapSerializable {
    private static final ImmutableSet<String> SKIP_HEADERS = ImmutableSet.of((Object)"okhttp-received-millis", (Object)"okhttp-selected-protocol", (Object)"okhttp-sent-millis");
    private static final ImmutableList<MediaType> TEXT_CONTENT_TYPES = ImmutableList.of((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"xml"), (Object)MediaType.create((String)"application", (String)"json"), (Object)MediaType.create((String)"application", (String)"javascript"), (Object)MediaType.create((String)"application", (String)"soap+xml"), (Object)MediaType.create((String)"application", (String)"xml"));
    private final CookieJar cookieJar;
    private final int status;
    private final String message;
    private final Headers headers;
    private final String contentType;
    private final ByteSource bodySource;
    private final String bodyString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMapper(Response response, CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        try {
            this.status = response.code();
            this.message = response.message();
            this.headers = response.headers();
            this.contentType = this.headers.get("content-type");
            boolean isHeadMethod = "HEAD".equalsIgnoreCase(response.request().method());
            this.bodySource = isHeadMethod ? ByteSource.empty() : this.getResponseBodyStream(response);
            this.bodyString = isHeadMethod ? "" : this.getResponseBodyString(this.bodySource);
        }
        finally {
            response.body().close();
        }
    }

    public void serialize(MapGenerator gen) {
        gen.value("status", (Object)this.status);
        gen.value("message", (Object)this.message);
        gen.value("body", (Object)this.bodyString);
        gen.value("bodyStream", (Object)this.bodySource);
        gen.value("contentType", (Object)this.contentType);
        this.serializeHeaders("headers", gen, this.headers);
        this.serializeCookies("cookies", gen, this.cookieJar.getCookies());
    }

    private Charset getCharset() {
        if (this.contentType == null) {
            return StandardCharsets.UTF_8;
        }
        try {
            MediaType type = MediaType.parse((String)this.contentType);
            return (Charset)type.charset().or((Object)StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return StandardCharsets.UTF_8;
        }
    }

    private String getResponseBodyString(ByteSource source) {
        try {
            return this.isTextContent() ? source.asCharSource(this.getCharset()).read() : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ByteSource getResponseBodyStream(Response response) {
        try {
            long bodyLength = response.body().contentLength();
            if (bodyLength == -1L || bodyLength > HttpRequestHandler.MAX_IN_MEMORY_BODY_STREAM_BYTES) {
                File tempFile = this.writeAsTmpFile(response.body().byteStream());
                return new RefFileByteSource(tempFile);
            }
            return ByteSource.wrap((byte[])response.body().bytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private File writeAsTmpFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile("xphttp", ".tmp");
        tempFile.deleteOnExit();
        Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tempFile;
    }

    private void serializeHeaders(String name, MapGenerator gen, Headers headers) {
        gen.map(name);
        for (String headerName : headers.names()) {
            if (SKIP_HEADERS.contains((Object)headerName.toLowerCase())) continue;
            gen.value(headerName, (Object)headers.get(headerName));
        }
        gen.end();
    }

    private void serializeCookies(String name, MapGenerator gen, List<Cookie> cookies) {
        gen.array(name);
        for (Cookie cookie : cookies) {
            gen.map();
            gen.value("name", (Object)cookie.name());
            gen.value("value", (Object)cookie.value());
            gen.value("path", (Object)cookie.path());
            gen.value("domain", (Object)cookie.domain());
            gen.value("expires", (Object)cookie.expiresAt());
            gen.value("secure", (Object)cookie.secure());
            gen.value("httpOnly", (Object)cookie.httpOnly());
            gen.end();
        }
        gen.end();
    }

    private boolean isTextContent() {
        if (StringUtils.isBlank((String)this.contentType)) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.parse((String)this.contentType);
            String subType = mediaType.subtype() == null ? "" : mediaType.subtype().toLowerCase();
            return TEXT_CONTENT_TYPES.stream().anyMatch(arg_0 -> ((MediaType)mediaType).is(arg_0)) || subType.contains("xml") || subType.contains("json");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

