/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.http.client;

import com.enonic.lib.http.client.HttpRequestHandler;
import com.enonic.lib.http.client.RefFileByteSource;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import okhttp3.Headers;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public final class ResponseMapper
implements MapSerializable {
    private static final ImmutableSet<String> SKIP_HEADERS = ImmutableSet.of((Object)"okhttp-received-millis", (Object)"okhttp-selected-protocol", (Object)"okhttp-sent-millis");
    private static final ImmutableList<MediaType> TEXT_CONTENT_TYPES = ImmutableList.of((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"xml"), (Object)MediaType.create((String)"application", (String)"json"), (Object)MediaType.create((String)"application", (String)"javascript"), (Object)MediaType.create((String)"application", (String)"soap+xml"), (Object)MediaType.create((String)"application", (String)"xml"));
    private final Response response;

    public ResponseMapper(Response response) {
        this.response = response;
    }

    public void serialize(MapGenerator gen) {
        gen.value("status", (Object)this.response.code());
        gen.value("message", (Object)this.response.message());
        String contentType = this.response.header("content-type");
        boolean isHeadMethod = "HEAD".equalsIgnoreCase(this.response.request().method());
        ByteSource bodySource = isHeadMethod ? ByteSource.empty() : this.getResponseBodyStream();
        String bodyString = isHeadMethod ? "" : this.getResponseBodyString(bodySource);
        gen.value("body", (Object)bodyString);
        gen.value("bodyStream", (Object)bodySource);
        gen.value("contentType", (Object)contentType);
        this.serializeHeaders("headers", gen, this.response.headers());
    }

    private Charset getCharset() {
        String contentType = this.response.header("content-type");
        if (contentType == null) {
            return StandardCharsets.UTF_8;
        }
        try {
            MediaType type = MediaType.parse((String)contentType);
            return (Charset)type.charset().or((Object)StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return StandardCharsets.UTF_8;
        }
    }

    private String getResponseBodyString(ByteSource source) {
        try {
            return this.isTextContent() ? source.asCharSource(this.getCharset()).read() : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ByteSource getResponseBodyStream() {
        try {
            long bodyLength = this.response.body().contentLength();
            if (bodyLength == -1L || bodyLength > HttpRequestHandler.MAX_IN_MEMORY_BODY_STREAM_BYTES) {
                File tempFile = this.writeAsTmpFile(this.response.body().byteStream());
                return new RefFileByteSource(tempFile);
            }
            return ByteSource.wrap((byte[])this.response.body().bytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private File writeAsTmpFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile("xphttp", ".tmp");
        tempFile.deleteOnExit();
        Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tempFile;
    }

    private void serializeHeaders(String name, MapGenerator gen, Headers headers) {
        gen.map(name);
        for (String headerName : headers.names()) {
            if (SKIP_HEADERS.contains((Object)headerName.toLowerCase())) continue;
            gen.value(headerName, (Object)headers.get(headerName));
        }
        gen.end();
    }

    private boolean isTextContent() {
        String contentType = this.response.header("content-type");
        if (StringUtils.isBlank((String)contentType)) {
            return false;
        }
        try {
            MediaType mediaType = MediaType.parse((String)contentType);
            String subType = mediaType.subtype() == null ? "" : mediaType.subtype().toLowerCase();
            return TEXT_CONTENT_TYPES.stream().anyMatch(arg_0 -> ((MediaType)mediaType).is(arg_0)) || subType.contains("xml") || subType.contains("json");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

