/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.http.client;

import com.enonic.lib.http.client.ResponseMapper;
import com.enonic.xp.trace.Trace;
import com.enonic.xp.trace.Tracer;
import com.google.common.io.ByteSource;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.apache.commons.lang.StringUtils;

public final class HttpRequestHandler {
    private static final int DEFAULT_PROXY_PORT = 8080;
    static long MAX_IN_MEMORY_BODY_STREAM_BYTES = 10000000L;
    private String url;
    private Map<String, Object> params;
    private String method = "GET";
    private Map<String, String> headers;
    private int connectionTimeout = 10000;
    private int readTimeout = 10000;
    private String contentType;
    private String bodyString;
    private ByteSource bodyStream;
    private List<Map<String, Object>> multipart;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String authUser;
    private String authPassword;
    private Trace trace;
    private static final OkHttpClient CLIENT = new OkHttpClient();

    public ResponseMapper request() throws Exception {
        this.startTracing();
        if (this.trace == null) {
            return this.executeRequest();
        }
        return (ResponseMapper)Tracer.traceEx((Trace)this.trace, this::executeRequest);
    }

    private ResponseMapper executeRequest() throws IOException {
        Response response = this.sendRequest(this.getRequest());
        this.endTracing(response);
        return new ResponseMapper(response);
    }

    private Response sendRequest(Request request) throws IOException {
        OkHttpClient.Builder clientBuilder = CLIENT.newBuilder();
        clientBuilder.readTimeout((long)this.readTimeout, TimeUnit.MILLISECONDS);
        clientBuilder.connectTimeout((long)this.connectionTimeout, TimeUnit.MILLISECONDS);
        this.setupProxy(clientBuilder);
        this.setupAuthentication(clientBuilder);
        return clientBuilder.build().newCall(request).execute();
    }

    private Request getRequest() throws IOException {
        MediaType mediaType;
        Request.Builder request = new Request.Builder();
        request.url(this.url);
        RequestBody requestBody = null;
        if (this.params != null && !this.params.isEmpty()) {
            FormBody.Builder formBody = new FormBody.Builder();
            this.addParams(formBody, this.params);
            requestBody = formBody.build();
        } else if (this.bodyString != null && !this.bodyString.isEmpty()) {
            mediaType = this.contentType != null ? MediaType.parse((String)this.contentType) : null;
            requestBody = RequestBody.create((MediaType)mediaType, (String)this.bodyString);
        } else if (this.bodyStream != null) {
            mediaType = this.contentType != null ? MediaType.parse((String)this.contentType) : null;
            requestBody = RequestBody.create((MediaType)mediaType, (byte[])this.bodyStream.read());
        } else if (this.multipart != null) {
            requestBody = this.getMultipartBody();
        }
        if ("GET".equals(this.method)) {
            HttpUrl url = HttpUrl.parse((String)this.url);
            if (this.params != null) {
                url = this.addParams(url, this.params);
            }
            request.url(url);
            if (this.contentType != null) {
                request.header("Content-Type", this.contentType);
            }
            request.get();
        } else {
            if (requestBody == null && HttpMethod.requiresRequestBody((String)this.method)) {
                mediaType = this.contentType != null ? MediaType.parse((String)this.contentType) : null;
                requestBody = RequestBody.create((MediaType)mediaType, (String)"");
            }
            request.method(this.method, requestBody);
        }
        this.addHeaders(request, this.headers);
        this.addAuthHeaders(request);
        return request.build();
    }

    private RequestBody getMultipartBody() throws IOException {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map<String, Object> multipartItem : this.multipart) {
            String name = this.getValue(multipartItem, "name");
            String fileName = this.getValue(multipartItem, "fileName");
            String contentType = this.getValue(multipartItem, "contentType");
            Object value = multipartItem.get("value");
            if (StringUtils.isBlank((String)name) || value == null) continue;
            if (value instanceof ByteSource) {
                ByteSource stream = (ByteSource)value;
                String ct = contentType == null ? "application/octet-stream" : contentType;
                MediaType partMediaType = MediaType.parse((String)ct);
                byte[] content = stream.read();
                RequestBody body = RequestBody.create((MediaType)partMediaType, (byte[])content);
                multipartBuilder.addFormDataPart(name, fileName, body);
                continue;
            }
            multipartBuilder.addFormDataPart(name, value.toString());
        }
        return multipartBuilder.build();
    }

    private String getValue(Map<String, Object> object, String key) {
        Object value = object.get(key);
        return value == null ? null : value.toString();
    }

    private HttpUrl addParams(HttpUrl url, Map<String, Object> params) {
        HttpUrl.Builder urlBuilder = url.newBuilder();
        params.entrySet().stream().filter(header -> header.getValue() != null).forEach(header -> urlBuilder.addEncodedQueryParameter((String)header.getKey(), header.getValue().toString()));
        return urlBuilder.build();
    }

    private void addParams(FormBody.Builder formBody, Map<String, Object> params) {
        params.entrySet().stream().filter(header -> header.getValue() != null).forEach(header -> formBody.add((String)header.getKey(), header.getValue().toString()));
    }

    private void addHeaders(Request.Builder request, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                request.header(header.getKey(), header.getValue());
            }
        }
    }

    private void setupProxy(OkHttpClient.Builder client) {
        if (this.proxyHost == null || this.proxyHost.trim().isEmpty()) {
            return;
        }
        int proxyPort = this.proxyPort == null ? 8080 : this.proxyPort;
        client.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, proxyPort)));
    }

    private void setupAuthentication(OkHttpClient.Builder client) {
        String authUser = this.authUser;
        String authPassword = this.authPassword;
        String proxyUser = this.proxyUser;
        String proxyPassword = this.proxyPassword;
        if ((proxyUser == null || proxyUser.isEmpty()) && (authUser == null || authUser.isEmpty())) {
            return;
        }
        Authenticator authenticator = (route, response) -> {
            if (authUser == null || authUser.trim().isEmpty()) {
                return null;
            }
            String credential = Credentials.basic((String)authUser, (String)authPassword);
            if (credential.equals(response.request().header("Authorization"))) {
                return null;
            }
            return response.request().newBuilder().header("Authorization", credential).build();
        };
        Authenticator proxyAuthenticator = (route, response) -> {
            if (proxyUser == null || proxyUser.trim().isEmpty()) {
                return null;
            }
            String credential = Credentials.basic((String)proxyUser, (String)proxyPassword);
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        };
        client.authenticator(authenticator);
        client.proxyAuthenticator(proxyAuthenticator);
    }

    private void addAuthHeaders(Request.Builder request) {
        if (this.authUser != null && this.authPassword != null) {
            String credential = Credentials.basic((String)this.authUser, (String)this.authPassword);
            request.header("Authorization", credential).build();
        }
    }

    private void startTracing() {
        this.trace = Tracer.newTrace((String)"httpClient");
        if (this.trace == null) {
            return;
        }
        this.trace.put((Object)"traceName", (Object)"HttpClient");
        this.trace.put((Object)"url", (Object)this.url);
        this.trace.put((Object)"method", (Object)this.method);
    }

    private void endTracing(Response response) {
        if (this.trace == null) {
            return;
        }
        if (response != null) {
            this.trace.put((Object)"status", (Object)response.code());
            this.trace.put((Object)"type", (Object)response.header("Content-Type"));
            Long length = Longs.tryParse((String)response.header("Content-Length"));
            if (length != null) {
                this.trace.put((Object)"size", (Object)length);
            }
        }
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBody(Object value) {
        this.bodyStream = null;
        this.bodyString = null;
        if (value == null) {
            return;
        }
        if (value instanceof ByteSource) {
            this.bodyStream = (ByteSource)value;
        } else {
            this.bodyString = value.toString();
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setMethod(String value) {
        if (value != null) {
            this.method = value.trim().toUpperCase();
        }
    }

    public void setConnectionTimeout(Integer value) {
        if (value != null) {
            this.connectionTimeout = value;
        }
    }

    public void setReadTimeout(Integer value) {
        if (value != null) {
            this.readTimeout = value;
        }
    }

    public void setMultipart(List<Map<String, Object>> multipart) {
        this.multipart = multipart;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }
}

