/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.serializer.IStandardJavaScriptSerializer;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.DateUtils;
import org.unbescape.json.JsonEscape;
import org.unbescape.json.JsonEscapeLevel;
import org.unbescape.json.JsonEscapeType;

public final class StandardJavaScriptSerializer
implements IStandardJavaScriptSerializer {
    private IStandardJavaScriptSerializer delegate;

    private static boolean isJacksonPresent() {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(StandardJavaScriptSerializer.class);
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper", false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public StandardJavaScriptSerializer(boolean useJacksonIfAvailable) {
        this.delegate = useJacksonIfAvailable && StandardJavaScriptSerializer.isJacksonPresent() ? new JacksonStandardJavaScriptSerializer() : new DefaultStandardJavaScriptSerializer();
    }

    @Override
    public void serializeValue(Object object, Writer writer) {
        this.delegate.serializeValue(object, writer);
    }

    private static final class DefaultStandardJavaScriptSerializer
    implements IStandardJavaScriptSerializer {
        private DefaultStandardJavaScriptSerializer() {
        }

        @Override
        public void serializeValue(Object object, Writer writer) {
            try {
                DefaultStandardJavaScriptSerializer.writeValue(writer, object);
            }
            catch (IOException e) {
                throw new TemplateProcessingException("An exception was raised while trying to serialize object to JavaScript using the default serializer", e);
            }
        }

        private static void writeValue(Writer writer, Object object) throws IOException {
            if (object == null) {
                DefaultStandardJavaScriptSerializer.writeNull(writer);
                return;
            }
            if (object instanceof CharSequence) {
                DefaultStandardJavaScriptSerializer.writeString(writer, object.toString());
                return;
            }
            if (object instanceof Character) {
                DefaultStandardJavaScriptSerializer.writeString(writer, object.toString());
                return;
            }
            if (object instanceof Number) {
                DefaultStandardJavaScriptSerializer.writeNumber(writer, (Number)object);
                return;
            }
            if (object instanceof Boolean) {
                DefaultStandardJavaScriptSerializer.writeBoolean(writer, (Boolean)object);
                return;
            }
            if (object instanceof Date) {
                DefaultStandardJavaScriptSerializer.writeDate(writer, (Date)object);
                return;
            }
            if (object instanceof Calendar) {
                DefaultStandardJavaScriptSerializer.writeDate(writer, ((Calendar)object).getTime());
                return;
            }
            if (object.getClass().isArray()) {
                DefaultStandardJavaScriptSerializer.writeArray(writer, object);
                return;
            }
            if (object instanceof Collection) {
                DefaultStandardJavaScriptSerializer.writeCollection(writer, (Collection)object);
                return;
            }
            if (object instanceof Map) {
                DefaultStandardJavaScriptSerializer.writeMap(writer, (Map)object);
                return;
            }
            if (object instanceof Enum) {
                DefaultStandardJavaScriptSerializer.writeEnum(writer, object);
                return;
            }
            DefaultStandardJavaScriptSerializer.writeObject(writer, object);
        }

        private static void writeNull(Writer writer) throws IOException {
            writer.write("null");
        }

        private static void writeString(Writer writer, String str) throws IOException {
            writer.write(34);
            writer.write(JsonEscape.escapeJson(str, JsonEscapeType.SINGLE_ESCAPE_CHARS_DEFAULT_TO_UHEXA, JsonEscapeLevel.LEVEL_2_ALL_NON_ASCII_PLUS_BASIC_ESCAPE_SET));
            writer.write(34);
        }

        private static void writeNumber(Writer writer, Number number) throws IOException {
            writer.write(number.toString());
        }

        private static void writeBoolean(Writer writer, Boolean bool) throws IOException {
            writer.write(bool.toString());
        }

        private static void writeDate(Writer writer, Date date) throws IOException {
            writer.write(34);
            writer.write(DateUtils.formatISO(date));
            writer.write(34);
        }

        private static void writeArray(Writer writer, Object arrayObj) throws IOException {
            writer.write(91);
            if (arrayObj instanceof Object[]) {
                Object[] array = (Object[])arrayObj;
                boolean first = true;
                for (Object element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof boolean[]) {
                boolean[] array = (boolean[])arrayObj;
                boolean first = true;
                for (boolean element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof byte[]) {
                byte[] array = (byte[])arrayObj;
                boolean first = true;
                for (byte element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof short[]) {
                short[] array = (short[])arrayObj;
                boolean first = true;
                for (short element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof int[]) {
                int[] array = (int[])arrayObj;
                boolean first = true;
                for (int element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof long[]) {
                long[] array = (long[])arrayObj;
                boolean first = true;
                for (long element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else if (arrayObj instanceof float[]) {
                float[] array = (float[])arrayObj;
                boolean first = true;
                for (float element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, Float.valueOf(element));
                }
            } else if (arrayObj instanceof double[]) {
                double[] array = (double[])arrayObj;
                boolean first = true;
                for (double element : array) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    DefaultStandardJavaScriptSerializer.writeValue(writer, element);
                }
            } else {
                throw new IllegalArgumentException("Cannot write value \"" + arrayObj + "\" of class " + arrayObj.getClass().getName() + " as an array");
            }
            writer.write(93);
        }

        private static void writeCollection(Writer writer, Collection<?> collection) throws IOException {
            writer.write(91);
            boolean first = true;
            for (Object element : collection) {
                if (first) {
                    first = false;
                } else {
                    writer.write(44);
                }
                DefaultStandardJavaScriptSerializer.writeValue(writer, element);
            }
            writer.write(93);
        }

        private static void writeMap(Writer writer, Map<?, ?> map) throws IOException {
            writer.write(123);
            boolean first = true;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(44);
                }
                DefaultStandardJavaScriptSerializer.writeKeyValue(writer, entry.getKey(), entry.getValue());
            }
            writer.write(125);
        }

        private static void writeKeyValue(Writer writer, Object key, Object value) throws IOException {
            DefaultStandardJavaScriptSerializer.writeValue(writer, key);
            writer.write(58);
            DefaultStandardJavaScriptSerializer.writeValue(writer, value);
        }

        private static void writeObject(Writer writer, Object object) throws IOException {
            try {
                PropertyDescriptor[] descriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(descriptors.length + 1, 1.0f);
                for (PropertyDescriptor descriptor : descriptors) {
                    String name;
                    Method readMethod = descriptor.getReadMethod();
                    if (readMethod == null || "class".equals((name = descriptor.getName()).toLowerCase())) continue;
                    Object value = readMethod.invoke(object, new Object[0]);
                    properties.put(name, value);
                }
                DefaultStandardJavaScriptSerializer.writeMap(writer, properties);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
            }
        }

        private static void writeEnum(Writer writer, Object object) throws IOException {
            Enum enumObject = (Enum)object;
            DefaultStandardJavaScriptSerializer.writeString(writer, enumObject.toString());
        }
    }

    private static final class JacksonThymeleafISO8601DateFormat
    extends DateFormat {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");

        JacksonThymeleafISO8601DateFormat() {
            this.setCalendar(this.dateFormat.getCalendar());
            this.setNumberFormat(this.dateFormat.getNumberFormat());
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            StringBuffer formatted = this.dateFormat.format(date, toAppendTo, fieldPosition);
            formatted.insert(26, ':');
            return formatted;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("JacksonThymeleafISO8601DateFormat should never be asked for a 'parse' operation");
        }
    }

    private static final class JacksonStandardJavaScriptSerializer
    implements IStandardJavaScriptSerializer {
        private final ObjectMapper mapper = new ObjectMapper();

        JacksonStandardJavaScriptSerializer() {
            this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
            this.mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.ESCAPE_NON_ASCII});
            this.mapper.setDateFormat((DateFormat)new JacksonThymeleafISO8601DateFormat());
        }

        @Override
        public void serializeValue(Object object, Writer writer) {
            try {
                this.mapper.writeValue(writer, object);
            }
            catch (IOException e) {
                throw new TemplateProcessingException("An exception was raised while trying to serialize object to JavaScript using Jackson", e);
            }
        }
    }
}

