/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ArrayPropertyAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapPropertyAccessor;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ExpressionCacheKey;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IContext;
import org.thymeleaf.standard.expression.OGNLContextPropertyAccessor;

final class OGNLShortcutExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(OGNLShortcutExpression.class);
    private static final String EXPRESSION_CACHE_TYPE_OGNL_SHORTCUT = "ognlsc";
    private static final Object[] NO_PARAMS = new Object[0];
    private final String[] expressionLevels;

    OGNLShortcutExpression(String[] expressionLevels) {
        this.expressionLevels = expressionLevels;
    }

    Object evaluate(IEngineConfiguration configuration, Map<String, Object> context, Object root) throws Exception {
        ICacheManager cacheManager = configuration.getCacheManager();
        ICache<ExpressionCacheKey, Object> expressionCache = cacheManager == null ? null : cacheManager.getExpressionCache();
        Object target = root;
        for (String propertyName : this.expressionLevels) {
            if (target == null) {
                throw new OgnlException("source is null for getProperty(null, \"" + propertyName + "\")");
            }
            Class targetClass = OgnlRuntime.getTargetClass(target);
            PropertyAccessor ognlPropertyAccessor = OgnlRuntime.getPropertyAccessor(targetClass);
            if (target instanceof Class) {
                target = OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, target);
                continue;
            }
            if (OGNLContextPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getContextProperty(propertyName, context, target);
                continue;
            }
            if (ObjectPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, target);
                continue;
            }
            if (MapPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getMapProperty(propertyName, (Map)target);
                continue;
            }
            if (ListPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getListProperty(expressionCache, propertyName, (List)target);
                continue;
            }
            if (SetPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getSetProperty(expressionCache, propertyName, (Set)target);
                continue;
            }
            if (IteratorPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getIteratorProperty(expressionCache, propertyName, (Iterator)target);
                continue;
            }
            if (EnumerationPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getEnumerationProperty(expressionCache, propertyName, (Enumeration)target);
                continue;
            }
            if (ArrayPropertyAccessor.class.equals(ognlPropertyAccessor.getClass())) {
                target = OGNLShortcutExpression.getArrayProperty(expressionCache, propertyName, (Object[])target);
                continue;
            }
            throw new OGNLShortcutExpressionNotApplicableException();
        }
        return target;
    }

    private static Object getContextProperty(String propertyName, Map<String, Object> context, Object target) throws OgnlException {
        Object execInfoResult;
        if ("param".equals(propertyName) && context != null && context.containsKey("%RESTRICT_REQUEST_PARAMETERS%")) {
            throw new OgnlException("Access to variable \"" + propertyName + "\" is forbidden in this context. Note some restrictions apply to " + "variable access. For example, accessing request parameters is forbidden in preprocessing and " + "unescaped expressions, and also in fragment inclusion specifications.");
        }
        if ("execInfo".equals(propertyName) && (execInfoResult = OGNLShortcutExpression.checkExecInfo(propertyName, context)) != null) {
            return execInfoResult;
        }
        return ((IContext)target).getVariable(propertyName);
    }

    @Deprecated
    private static Object checkExecInfo(String propertyName, Map<String, Object> context) {
        if ("execInfo".equals(propertyName)) {
            LOGGER.warn("[THYMELEAF][{}] Found Thymeleaf Standard Expression containing a call to the context variable \"execInfo\" (e.g. \"${execInfo.templateName}\"), which has been deprecated. The Execution Info should be now accessed as an expression object instead (e.g. \"${#execInfo.templateName}\"). Deprecated use is still allowed, but will be removed in future versions of Thymeleaf.", (Object)TemplateEngine.threadIndex());
            return context.get("execInfo");
        }
        return null;
    }

    private static Object getObjectProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, Object target) {
        Class currClass = OgnlRuntime.getTargetClass(target);
        ExpressionCacheKey cacheKey = OGNLShortcutExpression.computeMethodCacheKey(currClass, propertyName);
        Method readMethod = null;
        if (expressionCache != null) {
            readMethod = (Method)expressionCache.get(cacheKey);
        }
        if (readMethod == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(currClass);
            }
            catch (IntrospectionException e) {
                throw new OGNLShortcutExpressionNotApplicableException();
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    if (!propertyDescriptor.getName().equals(propertyName)) continue;
                    readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null || expressionCache == null) break;
                    expressionCache.put(cacheKey, readMethod);
                    break;
                }
            }
        }
        if (readMethod == null) {
            throw new OGNLShortcutExpressionNotApplicableException();
        }
        try {
            return readMethod.invoke(target, NO_PARAMS);
        }
        catch (IllegalAccessException e) {
            throw new OGNLShortcutExpressionNotApplicableException();
        }
        catch (InvocationTargetException e) {
            throw new OGNLShortcutExpressionNotApplicableException();
        }
    }

    private static Object getMapProperty(String propertyName, Map<?, ?> map) {
        if (propertyName.equals("size")) {
            return map.size();
        }
        if (propertyName.equals("keys") || propertyName.equals("keySet")) {
            return map.keySet();
        }
        if (propertyName.equals("values")) {
            return map.values();
        }
        if (propertyName.equals("isEmpty")) {
            return map.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        return map.get(propertyName);
    }

    public static Object getListProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, List<?> list) {
        if (propertyName.equals("size")) {
            return list.size();
        }
        if (propertyName.equals("iterator")) {
            return list.iterator();
        }
        if (propertyName.equals("isEmpty") || propertyName.equals("empty")) {
            return list.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        return OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, list);
    }

    public static Object getArrayProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, Object[] array) {
        if (propertyName.equals("length")) {
            return Array.getLength(array);
        }
        return OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, array);
    }

    public static Object getEnumerationProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, Enumeration enumeration) {
        if (propertyName.equals("next") || propertyName.equals("nextElement")) {
            return enumeration.nextElement();
        }
        if (propertyName.equals("hasNext") || propertyName.equals("hasMoreElements")) {
            return enumeration.hasMoreElements() ? Boolean.TRUE : Boolean.FALSE;
        }
        return OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, enumeration);
    }

    public static Object getIteratorProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, Iterator<?> iterator) {
        if (propertyName.equals("next")) {
            return iterator.next();
        }
        if (propertyName.equals("hasNext")) {
            return iterator.hasNext() ? Boolean.TRUE : Boolean.FALSE;
        }
        return OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, iterator);
    }

    public static Object getSetProperty(ICache<ExpressionCacheKey, Object> expressionCache, String propertyName, Set<?> set) {
        if (propertyName.equals("size")) {
            return set.size();
        }
        if (propertyName.equals("iterator")) {
            return set.iterator();
        }
        if (propertyName.equals("isEmpty")) {
            return set.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        return OGNLShortcutExpression.getObjectProperty(expressionCache, propertyName, set);
    }

    static String[] parse(String expression) {
        return OGNLShortcutExpression.doParseExpr(expression, 0, 0, expression.length());
    }

    private static String[] doParseExpr(String expression, int level, int offset, int len) {
        String[] result;
        int codepoint;
        int i;
        boolean firstChar = true;
        for (i = offset; i < len && (codepoint = Character.codePointAt(expression, i)) != 46; ++i) {
            if (firstChar) {
                if (!Character.isJavaIdentifierStart(codepoint)) {
                    return null;
                }
                firstChar = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(codepoint)) continue;
            return null;
        }
        if (i < len) {
            result = OGNLShortcutExpression.doParseExpr(expression, level + 1, i + 1, len);
            if (result == null) {
                return null;
            }
        } else {
            result = new String[level + 1];
        }
        result[level] = expression.substring(offset, i);
        if ("true".equalsIgnoreCase(result[level]) || "false".equalsIgnoreCase(result[level]) || "null".equalsIgnoreCase(result[level])) {
            return null;
        }
        return result;
    }

    private static ExpressionCacheKey computeMethodCacheKey(Class<?> targetClass, String propertyName) {
        return new ExpressionCacheKey(EXPRESSION_CACHE_TYPE_OGNL_SHORTCUT, targetClass.getName(), propertyName);
    }

    static class OGNLShortcutExpressionNotApplicableException
    extends RuntimeException {
        OGNLShortcutExpressionNotApplicableException() {
        }
    }
}

