/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thymeleaf.engine.IteratedGatheringModelProcessable;

public final class DataDrivenTemplateIterator
implements Iterator<Object> {
    private final List<Object> values = new ArrayList<Object>(10);
    private IteratedGatheringModelProcessable.IterationType iterationType = null;
    private boolean feedingComplete = false;

    @Override
    public boolean hasNext() {
        if (this.iterationType == null) {
            throw new IllegalStateException("hasNext(): Throttled iterator has not yet computed the iteration type");
        }
        return !this.values.isEmpty();
    }

    @Override
    public Object next() {
        if (this.iterationType == null) {
            throw new IllegalStateException("next(): Throttled iterator has not yet computed the iteration type");
        }
        if (this.values.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object value = this.values.get(0);
        this.values.remove(0);
        return value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in Throttled Iterator");
    }

    IteratedGatheringModelProcessable.IterationType getIterationType() {
        return this.iterationType;
    }

    boolean isPaused() {
        return this.iterationType == null || this.values.isEmpty() && !this.feedingComplete;
    }

    public boolean continueBufferExecution() {
        return this.iterationType != null && !this.values.isEmpty();
    }

    public void feedBuffer(List<Object> newElements) {
        this.values.addAll(newElements);
        if (this.iterationType == null && this.values.size() >= 2) {
            this.iterationType = IteratedGatheringModelProcessable.IterationType.MULTIPLE;
        }
    }

    public void feedingComplete() {
        this.feedingComplete = true;
        if (this.iterationType == null) {
            this.iterationType = this.values.isEmpty() ? IteratedGatheringModelProcessable.IterationType.ZERO : IteratedGatheringModelProcessable.IterationType.ONE;
        }
    }
}

