/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.portal.url;

import com.enonic.xp.portal.PortalRequest;
import com.enonic.xp.portal.PortalRequestAccessor;
import com.enonic.xp.portal.url.PortalUrlService;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;

public abstract class AbstractUrlHandler
implements ScriptBean {
    protected PortalRequest request;
    protected PortalUrlService urlService;

    protected abstract String buildUrl(Multimap<String, String> var1);

    public final String createUrl(ScriptValue params) {
        if (params == null) {
            return this.createUrl(Maps.newHashMap());
        }
        return this.createUrl(params.getMap());
    }

    private String createUrl(Map<String, Object> params) {
        Multimap<String, String> map = this.toMap(params);
        return this.buildUrl(map);
    }

    private Multimap<String, String> toMap(Map<String, Object> params) {
        HashMultimap map = HashMultimap.create();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            String key = param.getKey();
            if (key.equals("params")) {
                this.applyParams((Multimap<String, String>)map, param.getValue());
                continue;
            }
            if (!this.isValidParam(key)) continue;
            this.applyParam((Multimap<String, String>)map, "_" + key, param.getValue());
        }
        return map;
    }

    private void applyParams(Multimap<String, String> params, Object value) {
        if (value instanceof Map) {
            this.applyParams(params, (Map)value);
        }
    }

    private void applyParams(Multimap<String, String> params, Map<?, ?> value) {
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            String key = entry.getKey().toString();
            this.applyParam(params, key, entry.getValue());
        }
    }

    private void applyParam(Multimap<String, String> params, String key, Object value) {
        if (value instanceof Iterable) {
            this.applyParam(params, key, (Iterable)value);
        } else {
            params.put((Object)key, (Object)value.toString());
        }
    }

    private void applyParam(Multimap<String, String> params, String key, Iterable values) {
        for (Object value : values) {
            params.put((Object)key, (Object)value.toString());
        }
    }

    protected abstract boolean isValidParam(String var1);

    public void initialize(BeanContext context) {
        this.request = PortalRequestAccessor.get();
        this.urlService = (PortalUrlService)context.getService(PortalUrlService.class).get();
    }
}

