/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.portal.multipart;

import com.enonic.xp.lib.portal.multipart.MultipartFormMapper;
import com.enonic.xp.lib.portal.multipart.MultipartItemMapper;
import com.enonic.xp.portal.PortalRequest;
import com.enonic.xp.portal.PortalRequestAccessor;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.web.multipart.MultipartForm;
import com.enonic.xp.web.multipart.MultipartItem;
import com.enonic.xp.web.multipart.MultipartService;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.net.MediaType;

public final class MultipartHandler
implements ScriptBean {
    private static final ImmutableList<MediaType> TEXT_CONTENT_TYPES = ImmutableList.of((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"json"));
    private MultipartForm form;

    public MultipartFormMapper getForm() {
        return new MultipartFormMapper(this.form);
    }

    public MultipartItemMapper getItem(String name, int index) {
        if (this.form == null) {
            return null;
        }
        MultipartItem item = this.form.get(name, index);
        return item != null ? new MultipartItemMapper(item) : null;
    }

    public ByteSource getBytes(String name, int index) {
        if (this.form == null) {
            return null;
        }
        MultipartItem item = this.form.get(name, index);
        return item != null ? item.getBytes() : null;
    }

    public String getText(String name, int index) {
        block6: {
            MultipartItem item;
            block5: {
                if (this.form == null) {
                    return null;
                }
                item = this.form.get(name, index);
                if (item == null) {
                    return null;
                }
                MediaType contentType = item.getContentType();
                if (contentType == null) break block5;
                if (!TEXT_CONTENT_TYPES.stream().anyMatch(arg_0 -> ((MediaType)contentType).is(arg_0))) break block6;
            }
            return item.getAsString();
        }
        return null;
    }

    public void initialize(BeanContext context) {
        PortalRequest request = PortalRequestAccessor.get();
        MultipartService service = (MultipartService)context.getService(MultipartService.class).get();
        this.form = service.parse(request.getRawRequest());
    }
}

