/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.i18n;

import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.i18n.LocaleService;
import com.enonic.xp.i18n.MessageBundle;
import com.enonic.xp.lib.i18n.MapMapper;
import com.enonic.xp.portal.PortalRequest;
import com.enonic.xp.portal.PortalRequestAccessor;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.script.serializer.MapSerializable;
import com.enonic.xp.site.Site;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class LocaleScriptBean
implements ScriptBean {
    private Supplier<LocaleService> localeService;
    private ApplicationKey application;
    private static final String NOT_TRANSLATED_MESSAGE = "NOT_TRANSLATED";

    public String localize(String key, List<String> locales, ScriptValue values, String[] bundles) {
        String locale;
        MessageBundle bundle;
        if (bundles == null || bundles.length == 0) {
            bundles = new String[]{"i18n/phrases", "site/i18n/phrases"};
        }
        if ((bundle = this.getMessageBundle(locale = this.getPreferredLocale(locales, bundles), bundles)) == null) {
            return null;
        }
        String localizedMessage = bundle.localize(key, this.toArray(values));
        return localizedMessage != null ? localizedMessage : NOT_TRANSLATED_MESSAGE;
    }

    public MapSerializable getPhrases(List<String> locales, String ... bundleNames) {
        String locale = this.getPreferredLocale(locales, bundleNames);
        return new MapMapper(this.getMessageBundle(locale, bundleNames).asMap());
    }

    public List<String> getSupportedLocales(String ... bundleNames) {
        ApplicationKey applicationKey = this.getApplication();
        return this.localeService.get().getLocales(applicationKey, bundleNames).stream().map(Locale::toLanguageTag).sorted(String::compareTo).collect(Collectors.toList());
    }

    private String getPreferredLocale(List<String> localeTags, String[] bundleNames) {
        if (localeTags == null || localeTags.isEmpty()) {
            return null;
        }
        ApplicationKey applicationKey = this.getApplication();
        List locales = localeTags.stream().map(Locale::forLanguageTag).collect(Collectors.toList());
        Locale preferredLocale = this.localeService.get().getSupportedLocale(locales, applicationKey, bundleNames);
        return preferredLocale == null ? null : preferredLocale.toLanguageTag();
    }

    private MessageBundle getMessageBundle(String locale, String ... bundleNames) {
        ApplicationKey applicationKey = this.getApplication();
        Locale resolvedLocale = this.resolveLocale(locale);
        return this.localeService.get().getBundle(applicationKey, resolvedLocale, bundleNames);
    }

    private ApplicationKey getApplication() {
        if (this.application != null) {
            return this.application;
        }
        PortalRequest req = this.getRequest();
        return req != null ? req.getApplicationKey() : ApplicationKey.from(LocaleScriptBean.class);
    }

    private Locale resolveLocale(String locale) {
        return Strings.isNullOrEmpty((String)locale) ? this.resolveLocaleFromSite() : Locale.forLanguageTag(locale);
    }

    private Locale resolveLocaleFromSite() {
        PortalRequest request = this.getRequest();
        if (request == null) {
            return null;
        }
        Site site = request.getSite();
        if (site != null) {
            return site.getLanguage();
        }
        return null;
    }

    private Object[] toArray(ScriptValue value) {
        if (value != null && value.isArray()) {
            return this.toArray(value.getArray(String.class));
        }
        return new String[0];
    }

    private String[] toArray(List<String> value) {
        return value.toArray(new String[value.size()]);
    }

    public void setApplication(String application) {
        this.application = application == null ? null : ApplicationKey.from((String)application);
    }

    public void initialize(BeanContext context) {
        this.localeService = context.getService(LocaleService.class);
    }

    private PortalRequest getRequest() {
        return PortalRequestAccessor.get();
    }
}

