/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.context;

import com.enonic.xp.context.Context;
import com.enonic.xp.lib.common.PrincipalMapper;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.enonic.xp.security.Principal;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.PrincipalKeys;
import com.enonic.xp.security.User;
import com.enonic.xp.security.auth.AuthenticationInfo;

public final class ContextMapper
implements MapSerializable {
    private final Context context;

    public ContextMapper(Context context) {
        this.context = context;
    }

    public void serialize(MapGenerator gen) {
        gen.value("branch", (Object)this.context.getBranch().toString());
        gen.value("repository", (Object)this.context.getRepositoryId().toString());
        this.serializeAuthInfo(gen, this.context.getAuthInfo());
    }

    private void serializeAuthInfo(MapGenerator gen, AuthenticationInfo info) {
        if (info == null) {
            return;
        }
        gen.map("authInfo");
        this.serializeUser(gen, info.getUser());
        this.serializePrincipals(gen, info.getPrincipals());
        gen.end();
    }

    private void serializeUser(MapGenerator gen, User user) {
        if (user == null) {
            return;
        }
        gen.map("user");
        new PrincipalMapper((Principal)user).serialize(gen);
        gen.end();
    }

    private void serializePrincipals(MapGenerator gen, PrincipalKeys keys) {
        if (keys == null) {
            return;
        }
        gen.array("principals");
        for (PrincipalKey key : keys) {
            gen.value((Object)key.toString());
        }
        gen.end();
    }
}

