/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.context;

import com.enonic.xp.context.Context;
import com.enonic.xp.context.ContextBuilder;
import com.enonic.xp.lib.context.ContextMapper;
import com.enonic.xp.lib.context.ContextRunParams;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.IdProviderKey;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.RoleKeys;
import com.enonic.xp.security.SecurityConstants;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.User;
import com.enonic.xp.security.auth.AuthenticationInfo;
import com.enonic.xp.security.auth.AuthenticationToken;
import com.enonic.xp.security.auth.VerifiedUsernameAuthToken;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class ContextHandlerBean
implements ScriptBean {
    private Supplier<Context> context;
    private Supplier<SecurityService> securityService;

    public Object run(ContextRunParams params) {
        ContextBuilder builder = ContextBuilder.from((Context)this.context.get());
        this.applyRepository(builder, params.repository);
        this.applyAuthInfo(builder, params.username, params.idProvider, params.principals);
        this.applyBranch(builder, params.branch);
        this.addAttributes(builder, params.attributes);
        return builder.build().callWith(params.callback);
    }

    public ContextMapper get() {
        return new ContextMapper(this.context.get());
    }

    public ContextRunParams newRunParams() {
        return new ContextRunParams();
    }

    private void applyRepository(ContextBuilder builder, String repository) {
        if (repository == null) {
            return;
        }
        builder.repositoryId(repository);
    }

    private void applyAuthInfo(ContextBuilder builder, String username, String idProvider, PrincipalKey[] principals) {
        AuthenticationInfo authInfo = this.context.get().getAuthInfo();
        if (username != null) {
            authInfo = this.runAsAuthenticated(() -> this.getAuthenticationInfo(username, idProvider));
        }
        if (principals != null) {
            authInfo = AuthenticationInfo.copyOf((AuthenticationInfo)authInfo).principals(principals).build();
        }
        builder.authInfo(authInfo);
    }

    private void applyBranch(ContextBuilder builder, String branch) {
        if (branch == null) {
            return;
        }
        builder.branch(branch);
    }

    private void addAttributes(ContextBuilder builder, Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                builder.attribute(attribute.getKey(), attribute.getValue());
            }
        }
    }

    private AuthenticationInfo getAuthenticationInfo(String username, String idProvider) {
        VerifiedUsernameAuthToken token = new VerifiedUsernameAuthToken();
        token.setUsername(username);
        token.setIdProvider(idProvider == null ? null : IdProviderKey.from((String)idProvider));
        return this.securityService.get().authenticate((AuthenticationToken)token);
    }

    private <T> T runAsAuthenticated(Callable<T> runnable) {
        AuthenticationInfo authInfo = AuthenticationInfo.create().principals(new PrincipalKey[]{RoleKeys.AUTHENTICATED}).user(User.ANONYMOUS).build();
        return (T)ContextBuilder.from((Context)this.context.get()).authInfo(authInfo).repositoryId(SecurityConstants.SECURITY_REPO.getId()).branch(SecurityConstants.BRANCH_SECURITY).build().callWith(runnable);
    }

    public void initialize(BeanContext context) {
        this.context = context.getBinding(Context.class);
        this.securityService = context.getService(SecurityService.class);
    }
}

