/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentIds;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.PublishContentResult;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import java.util.List;

public class PushContentResultMapper
implements MapSerializable {
    private final PublishContentResult value;
    private final List<ContentPath> contentNotFound;

    public PushContentResultMapper(PublishContentResult value, List<ContentPath> contentNotFound) {
        this.value = value;
        this.contentNotFound = contentNotFound;
    }

    public void serialize(MapGenerator gen) {
        this.serialize(gen, this.value);
    }

    private void serialize(MapGenerator gen, PublishContentResult value) {
        this.serializeContentIds(gen, "pushedContents", value.getPushedContents());
        this.serializeContentIds(gen, "deletedContents", value.getDeletedContents());
        this.serializeFailedContent(gen, "failedContents", value.getFailedContents());
    }

    private void serializeContentIds(MapGenerator gen, String name, ContentIds contents) {
        gen.array(name);
        for (ContentId id : contents) {
            gen.value((Object)id.toString());
        }
        gen.end();
    }

    private void serializeFailedContent(MapGenerator gen, String name, ContentIds contents) {
        gen.array(name);
        for (ContentId id : contents) {
            gen.value((Object)id.toString());
        }
        for (ContentPath path : this.contentNotFound) {
            gen.value((Object)path.toString());
        }
        gen.end();
    }
}

