/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.content.Content;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.enonic.xp.security.acl.AccessControlEntry;
import com.enonic.xp.security.acl.Permission;

public final class PermissionsMapper
implements MapSerializable {
    private final Content content;

    public PermissionsMapper(Content content) {
        this.content = content;
    }

    public void serialize(MapGenerator gen) {
        gen.value("inheritsPermissions", (Object)this.content.inheritsPermissions());
        if (!this.content.getPermissions().isEmpty()) {
            gen.array("permissions");
            for (AccessControlEntry accessControlEntry : this.content.getPermissions()) {
                gen.map();
                this.serialize(gen, accessControlEntry);
                gen.end();
            }
            gen.end();
        }
    }

    private void serialize(MapGenerator gen, AccessControlEntry accessControlEntry) {
        gen.value("principal", (Object)accessControlEntry.getPrincipal().toString());
        gen.array("allow");
        for (Permission permission : accessControlEntry.getAllowedPermissions()) {
            gen.value((Object)permission.toString());
        }
        gen.end();
        gen.array("deny");
        for (Permission permission : accessControlEntry.getDeniedPermissions()) {
            gen.value((Object)permission.toString());
        }
        gen.end();
    }
}

