/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.lib.content.mapper.ComponentMapper;
import com.enonic.xp.lib.content.mapper.RegionMapper;
import com.enonic.xp.page.Page;
import com.enonic.xp.page.PageRegions;
import com.enonic.xp.region.Component;
import com.enonic.xp.region.Region;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;

public final class PageMapper
implements MapSerializable {
    static final String PAGE = "page";
    static final String TEMPLATE = "template";
    private final Page value;

    public PageMapper(Page value) {
        this.value = value;
    }

    public void serialize(MapGenerator gen) {
        this.serialize(gen, this.value);
    }

    private void serialize(MapGenerator gen, Page value) {
        if (value.isFragment()) {
            this.serializeFragment(gen, value.getFragment());
        } else {
            this.serializePage(gen, value);
        }
    }

    private void serializeFragment(MapGenerator gen, Component value) {
        gen.map("fragment");
        new ComponentMapper(value).serialize(gen);
        gen.end();
    }

    private void serializePage(MapGenerator gen, Page value) {
        gen.map(PAGE);
        gen.value("type", (Object)PAGE);
        gen.value("path", (Object)"/");
        gen.value(TEMPLATE, (Object)value.getTemplate());
        gen.value("descriptor", (Object)value.getDescriptor());
        if (value.hasConfig()) {
            gen.map("config");
            new PropertyTreeMapper(value.getConfig()).serialize(gen);
            gen.end();
        }
        if (value.hasRegions()) {
            this.serializeRegions(gen, value.getRegions());
        }
        gen.end();
    }

    private void serializeRegions(MapGenerator gen, PageRegions values) {
        gen.map("regions");
        if (values != null) {
            for (Region region : values) {
                new RegionMapper(region).serialize(gen);
            }
        }
        gen.end();
    }
}

