/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.icon.Icon;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;

public final class IconByteSource
extends ByteSource {
    private final Icon icon;

    IconByteSource(Icon icon) {
        this.icon = icon;
    }

    public InputStream openStream() {
        return this.icon.asInputStream();
    }

    public InputStream openBufferedStream() throws IOException {
        return this.openStream();
    }

    public boolean isEmpty() {
        return this.icon == null || this.icon.getSize() == 0;
    }

    public long size() {
        return this.isEmpty() ? 0L : (long)this.icon.getSize();
    }

    public byte[] read() throws IOException {
        return ByteStreams.toByteArray((InputStream)this.icon.asInputStream());
    }

    public <T> T read(ByteProcessor<T> processor) throws IOException {
        processor.processBytes(this.read(), 0, this.icon.getSize());
        return (T)processor.getResult();
    }

    public String toString() {
        return "IconStream(" + this.size() + ")";
    }
}

