/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.aggregation.Aggregations;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.Contents;
import com.enonic.xp.lib.content.mapper.AggregationMapper;
import com.enonic.xp.lib.content.mapper.ContentMapper;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;

public final class ContentsResultMapper
implements MapSerializable {
    private final Contents contents;
    private final long total;
    private final Aggregations aggregations;

    public ContentsResultMapper(Contents contents, long total) {
        this.contents = contents;
        this.total = total;
        this.aggregations = null;
    }

    public ContentsResultMapper(Contents contents, long total, Aggregations aggregations) {
        this.contents = contents;
        this.total = total;
        this.aggregations = aggregations;
    }

    public void serialize(MapGenerator gen) {
        gen.value("total", (Object)this.total);
        gen.value("count", (Object)this.contents.getSize());
        this.serialize(gen, this.contents);
        this.serialize(gen, this.aggregations);
    }

    private void serialize(MapGenerator gen, Contents contents) {
        gen.array("hits");
        for (Content content : contents) {
            gen.map();
            new ContentMapper(content).serialize(gen);
            gen.end();
        }
        gen.end();
    }

    private void serialize(MapGenerator gen, Aggregations aggregations) {
        if (aggregations != null) {
            gen.map("aggregations");
            new AggregationMapper(aggregations).serialize(gen);
            gen.end();
        }
    }
}

