/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.data.Value;
import com.enonic.xp.form.FieldSet;
import com.enonic.xp.form.Form;
import com.enonic.xp.form.FormItem;
import com.enonic.xp.form.FormItemSet;
import com.enonic.xp.form.FormOptionSet;
import com.enonic.xp.form.FormOptionSetOption;
import com.enonic.xp.form.InlineMixin;
import com.enonic.xp.form.Input;
import com.enonic.xp.form.Layout;
import com.enonic.xp.form.Occurrences;
import com.enonic.xp.icon.Icon;
import com.enonic.xp.inputtype.InputTypeConfig;
import com.enonic.xp.inputtype.InputTypeProperty;
import com.enonic.xp.inputtype.InputTypes;
import com.enonic.xp.lib.content.mapper.IconByteSource;
import com.enonic.xp.schema.content.ContentType;
import com.enonic.xp.schema.content.ContentTypeName;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import java.util.Map;

public final class ContentTypeMapper
implements MapSerializable {
    private final ContentType contentType;

    public ContentTypeMapper(ContentType contentType) {
        this.contentType = contentType;
    }

    public void serialize(MapGenerator gen) {
        gen.value("name", (Object)((ContentTypeName)this.contentType.getName()).toString());
        gen.value("displayName", (Object)this.contentType.getDisplayName());
        gen.value("description", (Object)this.contentType.getDescription());
        gen.value("superType", this.contentType.getSuperType() == null ? null : this.contentType.getSuperType().toString());
        gen.value("abstract", (Object)this.contentType.isAbstract());
        gen.value("final", (Object)this.contentType.isFinal());
        gen.value("allowChildContent", (Object)this.contentType.allowChildContent());
        gen.value("displayNameExpression", (Object)this.contentType.getDisplayNameExpression());
        this.serializeIcon(gen, this.contentType.getIcon());
        this.serializeForm(gen, this.contentType.getForm());
    }

    private void serializeIcon(MapGenerator gen, Icon icon) {
        if (icon == null || icon.getSize() == 0) {
            return;
        }
        gen.map("icon");
        gen.value("data", (Object)new IconByteSource(icon));
        gen.value("mimeType", (Object)icon.getMimeType());
        gen.value("modifiedTime", (Object)icon.getModifiedTime());
        gen.end();
    }

    private void serializeForm(MapGenerator gen, Form form) {
        gen.array("form");
        for (FormItem item : form) {
            this.serializeItem(gen, item);
        }
        gen.end();
    }

    private void serializeItem(MapGenerator gen, FormItem item) {
        if (item instanceof FormItemSet) {
            this.serializeFormItemSet(gen, (FormItemSet)item);
        } else if (item instanceof Layout) {
            this.serializeLayout(gen, (FieldSet)item);
        } else if (item instanceof Input) {
            this.serializeInput(gen, (Input)item);
        } else if (!(item instanceof InlineMixin) && item instanceof FormOptionSet) {
            this.serializeFormOptionSet(gen, (FormOptionSet)item);
        }
    }

    private void serializeOccurrences(MapGenerator gen, Occurrences occurrences) {
        gen.map("occurrences");
        gen.value("maximum", (Object)occurrences.getMaximum());
        gen.value("minimum", (Object)occurrences.getMinimum());
        gen.end();
    }

    private void serializeFormOptionSet(MapGenerator gen, FormOptionSet optionSet) {
        gen.map();
        gen.value("formItemType", (Object)"OptionSet");
        gen.value("name", (Object)optionSet.getName());
        gen.value("label", (Object)optionSet.getLabel());
        gen.value("expanded", (Object)optionSet.isExpanded());
        gen.value("helpText", (Object)optionSet.getHelpText());
        this.serializeOccurrences(gen, optionSet.getOccurrences());
        this.serializeMultiselection(gen, optionSet.getMultiselection());
        gen.array("options");
        for (FormOptionSetOption option : optionSet) {
            this.serializeOption(gen, option);
        }
        gen.end();
        gen.end();
    }

    private void serializeOption(MapGenerator gen, FormOptionSetOption option) {
        gen.map();
        gen.value("name", (Object)option.getName());
        gen.value("label", (Object)option.getLabel());
        gen.value("helpText", (Object)option.getHelpText());
        gen.value("default", (Object)option.isDefaultOption());
        gen.array("items");
        for (FormItem formItem : option.getFormItems()) {
            this.serializeItem(gen, formItem);
        }
        gen.end();
        gen.end();
    }

    private void serializeMultiselection(MapGenerator gen, Occurrences multiselection) {
        gen.map("selection");
        gen.value("maximum", (Object)multiselection.getMaximum());
        gen.value("minimum", (Object)multiselection.getMinimum());
        gen.end();
    }

    private void serializeInput(MapGenerator gen, Input input) {
        gen.map();
        gen.value("formItemType", (Object)"Input");
        gen.value("name", (Object)input.getName());
        gen.value("label", (Object)input.getLabel());
        gen.value("customText", (Object)input.getCustomText());
        gen.value("helpText", (Object)input.getHelpText());
        gen.value("validationRegexp", (Object)input.getValidationRegexp());
        gen.value("maximize", (Object)input.isMaximizeUIInputWidth());
        gen.value("inputType", (Object)input.getInputType().toString());
        this.serializeOccurrences(gen, input.getOccurrences());
        this.serializeDefaultValue(gen, input);
        this.serializeConfig(gen, input.getInputTypeConfig());
        gen.end();
    }

    private void serializeConfig(MapGenerator gen, InputTypeConfig config) {
        gen.map("config");
        for (String name : config.getNames()) {
            gen.array(name);
            for (InputTypeProperty property : config.getProperties(name)) {
                this.serializeConfigProperty(gen, property);
            }
            gen.end();
        }
        gen.end();
    }

    private void serializeConfigProperty(MapGenerator gen, InputTypeProperty property) {
        gen.map();
        gen.value("value", (Object)property.getValue());
        for (Map.Entry attribute : property.getAttributes().entrySet()) {
            gen.value("@" + (String)attribute.getKey(), attribute.getValue());
        }
        gen.end();
    }

    private void serializeDefaultValue(MapGenerator gen, Input input) {
        if (input.getDefaultValue() != null) {
            try {
                Value defaultValue = InputTypes.BUILTIN.resolve(input.getInputType()).createDefaultValue(input);
                if (defaultValue != null) {
                    gen.map("default");
                    gen.value("value", defaultValue.getObject());
                    gen.value("type", (Object)defaultValue.getType().getName());
                    gen.end();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void serializeLayout(MapGenerator gen, FieldSet fieldSet) {
        gen.map();
        gen.value("formItemType", (Object)"Layout");
        gen.value("name", (Object)fieldSet.getName());
        gen.value("label", (Object)fieldSet.getLabel());
        gen.array("items");
        for (FormItem formItem : fieldSet) {
            this.serializeItem(gen, formItem);
        }
        gen.end();
        gen.end();
    }

    private void serializeFormItemSet(MapGenerator gen, FormItemSet itemSet) {
        gen.map();
        gen.value("formItemType", (Object)"ItemSet");
        gen.value("name", (Object)itemSet.getName());
        gen.value("label", (Object)itemSet.getLabel());
        gen.value("customText", (Object)itemSet.getCustomText());
        gen.value("helpText", (Object)itemSet.getHelpText());
        this.serializeOccurrences(gen, itemSet.getOccurrences());
        gen.array("items");
        for (FormItem formItem : itemSet) {
            this.serializeItem(gen, formItem);
        }
        gen.end();
        gen.end();
    }
}

