/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.attachment.Attachments;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentPublishInfo;
import com.enonic.xp.content.ExtraData;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.lib.content.mapper.AttachmentsMapper;
import com.enonic.xp.lib.content.mapper.PageMapper;
import com.enonic.xp.page.Page;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.google.common.collect.ArrayListMultimap;
import java.util.List;

public final class ContentMapper
implements MapSerializable {
    private final Content value;

    public ContentMapper(Content value) {
        this.value = value;
    }

    private static void serialize(MapGenerator gen, Content value) {
        gen.value("_id", (Object)value.getId());
        gen.value("_name", (Object)value.getName());
        gen.value("_path", (Object)value.getPath());
        gen.value("creator", (Object)value.getCreator());
        gen.value("modifier", (Object)value.getModifier());
        gen.value("createdTime", (Object)value.getCreatedTime());
        gen.value("modifiedTime", (Object)value.getModifiedTime());
        gen.value("owner", (Object)value.getOwner());
        gen.value("type", (Object)value.getType());
        gen.value("displayName", (Object)value.getDisplayName());
        gen.value("hasChildren", (Object)value.hasChildren());
        gen.value("language", (Object)value.getLanguage());
        gen.value("valid", (Object)value.isValid());
        if (value.getChildOrder() != null) {
            gen.value("childOrder", (Object)value.getChildOrder().toString());
        }
        ContentMapper.serializeData(gen, value.getData());
        ContentMapper.serializeExtraData(gen, (Iterable<ExtraData>)value.getAllExtraData());
        ContentMapper.serializePage(gen, value.getPage());
        ContentMapper.serializeAttachments(gen, value.getAttachments());
        ContentMapper.serializePublishInfo(gen, value.getPublishInfo());
    }

    private static void serializeData(MapGenerator gen, PropertyTree value) {
        gen.map("data");
        new PropertyTreeMapper(value).serialize(gen);
        gen.end();
    }

    private static void serializePublishInfo(MapGenerator gen, ContentPublishInfo info) {
        gen.map("publish");
        if (info != null) {
            gen.value("from", (Object)info.getFrom());
            gen.value("to", (Object)info.getTo());
            gen.value("first", (Object)info.getFirst());
        }
        gen.end();
    }

    private static void serializeExtraData(MapGenerator gen, Iterable<ExtraData> values) {
        gen.map("x");
        ArrayListMultimap extradatasByModule = ArrayListMultimap.create();
        for (ExtraData extraData : values) {
            extradatasByModule.put((Object)extraData.getName().getApplicationKey(), (Object)extraData);
        }
        for (ApplicationKey applicationKey : extradatasByModule.keys()) {
            List extraDatas = extradatasByModule.get((Object)applicationKey);
            if (extraDatas.isEmpty()) continue;
            gen.map(((ExtraData)extraDatas.get(0)).getApplicationPrefix());
            for (ExtraData extraData : extraDatas) {
                gen.map(extraData.getName().getLocalName());
                new PropertyTreeMapper(extraData.getData()).serialize(gen);
                gen.end();
            }
            gen.end();
        }
        gen.end();
    }

    private static void serializePage(MapGenerator gen, Page value) {
        if (value != null) {
            new PageMapper(value).serialize(gen);
        } else {
            gen.map("page");
            gen.end();
        }
    }

    private static void serializeAttachments(MapGenerator gen, Attachments value) {
        gen.map("attachments");
        if (value != null) {
            new AttachmentsMapper(value).serialize(gen);
        }
        gen.end();
    }

    public void serialize(MapGenerator gen) {
        ContentMapper.serialize(gen, this.value);
    }
}

