/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.lib.content.mapper.RegionMapper;
import com.enonic.xp.region.Component;
import com.enonic.xp.region.DescriptorBasedComponent;
import com.enonic.xp.region.FragmentComponent;
import com.enonic.xp.region.LayoutComponent;
import com.enonic.xp.region.Region;
import com.enonic.xp.region.TextComponent;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;

public final class ComponentMapper
implements MapSerializable {
    static final String TYPE = "type";
    static final String PATH = "path";
    static final String DESCRIPTOR = "descriptor";
    static final String CONFIG = "config";
    static final String TEXT = "text";
    static final String REGIONS = "regions";
    static final String FRAGMENT = "fragment";
    private final Component value;

    public ComponentMapper(Component value) {
        this.value = value;
    }

    public void serialize(MapGenerator gen) {
        this.serialize(gen, this.value);
    }

    private void serialize(MapGenerator gen, Component value) {
        gen.value(PATH, (Object)value.getPath());
        gen.value(TYPE, (Object)value.getType());
        if (value instanceof DescriptorBasedComponent) {
            this.serialize(gen, (DescriptorBasedComponent)value);
        }
        if (value instanceof LayoutComponent) {
            this.serialize(gen, (LayoutComponent)value);
        } else if (value instanceof TextComponent) {
            this.serialize(gen, (TextComponent)value);
        } else if (value instanceof FragmentComponent) {
            this.serialize(gen, (FragmentComponent)value);
        }
    }

    private void serialize(MapGenerator gen, DescriptorBasedComponent comp) {
        gen.value(DESCRIPTOR, (Object)comp.getDescriptor());
        if (comp.getConfig() != null) {
            gen.map(CONFIG);
            new PropertyTreeMapper(comp.getConfig()).serialize(gen);
            gen.end();
        }
    }

    private void serialize(MapGenerator gen, LayoutComponent comp) {
        gen.map(REGIONS);
        for (Region region : comp.getRegions()) {
            new RegionMapper(region).serialize(gen);
        }
        gen.end();
    }

    private void serialize(MapGenerator gen, FragmentComponent comp) {
        gen.value(FRAGMENT, (Object)comp.getFragment());
    }

    private void serialize(MapGenerator gen, TextComponent comp) {
        gen.value(TEXT, (Object)comp.getText());
    }
}

