/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content.mapper;

import com.enonic.xp.aggregation.Aggregation;
import com.enonic.xp.aggregation.Aggregations;
import com.enonic.xp.aggregation.Bucket;
import com.enonic.xp.aggregation.BucketAggregation;
import com.enonic.xp.aggregation.Buckets;
import com.enonic.xp.aggregation.DateRangeBucket;
import com.enonic.xp.aggregation.NumericRangeBucket;
import com.enonic.xp.aggregation.StatsAggregation;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;

public final class AggregationMapper
implements MapSerializable {
    private final Aggregations value;

    public AggregationMapper(Aggregations value) {
        this.value = value;
    }

    public void serialize(MapGenerator gen) {
        AggregationMapper.serializeAggregations(gen, this.value);
    }

    private static void serializeAggregations(MapGenerator gen, Aggregations value) {
        for (Aggregation aggregation : value) {
            gen.map(aggregation.getName());
            if (aggregation instanceof BucketAggregation) {
                Buckets buckets = ((BucketAggregation)aggregation).getBuckets();
                AggregationMapper.serializeBuckets(gen, buckets);
            } else if (aggregation instanceof StatsAggregation) {
                StatsAggregation statsAggregation = (StatsAggregation)aggregation;
                AggregationMapper.serializeStatsAggregation(gen, statsAggregation);
            }
            gen.end();
        }
    }

    private static void serializeBuckets(MapGenerator gen, Buckets value) {
        gen.array("buckets");
        for (Bucket bucket : value) {
            AggregationMapper.serializeBucket(gen, bucket);
        }
        gen.end();
    }

    private static void serializeBucket(MapGenerator gen, Bucket value) {
        gen.map();
        gen.value("key", (Object)value.getKey());
        gen.value("docCount", (Object)value.getDocCount());
        if (value instanceof DateRangeBucket) {
            AggregationMapper.serializeDateBucket(gen, (DateRangeBucket)value);
        } else if (value instanceof NumericRangeBucket) {
            AggregationMapper.serializeNumericBucket(gen, (NumericRangeBucket)value);
        }
        Aggregations subAggregations = value.getSubAggregations();
        if (subAggregations != null) {
            AggregationMapper.serializeAggregations(gen, subAggregations);
        }
        gen.end();
    }

    private static void serializeNumericBucket(MapGenerator gen, NumericRangeBucket value) {
        gen.value("from", (Object)value.getFrom());
        gen.value("to", (Object)value.getTo());
    }

    private static void serializeDateBucket(MapGenerator gen, DateRangeBucket value) {
        gen.value("from", (Object)value.getFrom());
        gen.value("to", (Object)value.getTo());
    }

    private static void serializeStatsAggregation(MapGenerator gen, StatsAggregation value) {
        gen.value("count", (Object)value.getCount());
        gen.value("min", (Object)value.getMin());
        gen.value("max", (Object)value.getMax());
        gen.value("avg", (Object)value.getAvg());
        gen.value("sum", (Object)value.getSum());
    }
}

