/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.branch.Branch;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentConstants;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentIds;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.ContentService;
import com.enonic.xp.content.UnpublishContentParams;
import com.enonic.xp.content.UnpublishContentsResult;
import com.enonic.xp.context.Context;
import com.enonic.xp.context.ContextAccessor;
import com.enonic.xp.context.ContextBuilder;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class UnpublishContentHandler
implements ScriptBean {
    private String[] keys;
    private ContentService contentService;

    public List<String> execute() {
        Branch targetBranch = ContentConstants.BRANCH_MASTER;
        Context context = ContextBuilder.from((Context)ContextAccessor.current()).branch(targetBranch).build();
        List contentIds = (List)context.callWith(this::resolveContentIds);
        UnpublishContentParams unpublishContentParams = UnpublishContentParams.create().contentIds(ContentIds.from((Iterable)contentIds)).unpublishBranch(targetBranch).includeChildren(true).build();
        UnpublishContentsResult result = this.contentService.unpublishContent(unpublishContentParams);
        return result.getUnpublishedContents().stream().map(ContentId::toString).collect(Collectors.toList());
    }

    private List<ContentId> resolveContentIds() {
        ArrayList<ContentId> contentIds = new ArrayList<ContentId>();
        for (String key : this.keys) {
            if (key.startsWith("/")) {
                ContentPath path = ContentPath.from((String)key);
                Content content = this.getByPath(path);
                if (content == null) continue;
                contentIds.add(content.getId());
                continue;
            }
            contentIds.add(ContentId.from((String)key));
        }
        return contentIds;
    }

    private Content getByPath(ContentPath contentPath) {
        try {
            return this.contentService.getByPath(contentPath);
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void initialize(BeanContext context) {
        this.contentService = (ContentService)context.getService(ContentService.class).get();
    }
}

