/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.ApplyContentPermissionsParams;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.ContentService;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.SecurityService;
import com.enonic.xp.security.acl.AccessControlEntry;
import com.enonic.xp.security.acl.AccessControlList;
import com.enonic.xp.security.acl.Permission;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SetPermissionsHandler
implements ScriptBean {
    private static final Logger LOG = LoggerFactory.getLogger(SetPermissionsHandler.class);
    private ContentService contentService;
    private SecurityService securityService;
    private String key;
    private boolean inheritPermissions;
    private boolean overwriteChildPermissions;
    private AccessControlList permissions;

    public void setKey(String key) {
        this.key = key;
    }

    public void setInheritPermissions(boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public void setOverwriteChildPermissions(boolean overwriteChildPermissions) {
        this.overwriteChildPermissions = overwriteChildPermissions;
    }

    public void setPermissions(ScriptValue permissions) {
        if (permissions != null) {
            List accessControlEntries = permissions.getArray().stream().map(this::convertToAccessControlEntry).collect(Collectors.toList());
            this.permissions = AccessControlList.create().addAll(accessControlEntries).build();
        }
    }

    private AccessControlEntry convertToAccessControlEntry(ScriptValue permission) {
        String principal = (String)permission.getMember("principal").getValue(String.class);
        List allowedPermissions = permission.getMember("allow").getArray(String.class).stream().map(Permission::valueOf).collect(Collectors.toList());
        List deniedPermissions = permission.getMember("deny").getArray(String.class).stream().map(Permission::valueOf).collect(Collectors.toList());
        return AccessControlEntry.create().principal(PrincipalKey.from((String)principal)).allow(allowedPermissions).deny(deniedPermissions).build();
    }

    public boolean execute() {
        return this.doExecute();
    }

    private boolean doExecute() {
        ContentId contentId = this.getContentId();
        if (!this.validPrincipals()) {
            return false;
        }
        if (contentId != null) {
            this.contentService.applyPermissions(ApplyContentPermissionsParams.create().contentId(contentId).permissions(this.permissions).inheritPermissions(this.inheritPermissions).overwriteChildPermissions(this.overwriteChildPermissions).build());
            return true;
        }
        return false;
    }

    private ContentId getContentId() {
        block4: {
            try {
                if (this.key.startsWith("/")) {
                    Content content = this.contentService.getByPath(ContentPath.from((String)this.key));
                    if (content != null) {
                        return content.getId();
                    }
                    break block4;
                }
                return ContentId.from((String)this.key);
            }
            catch (ContentNotFoundException e) {
                LOG.warn("Content not found: " + this.key);
            }
        }
        return null;
    }

    private boolean validPrincipals() {
        boolean valid = true;
        for (PrincipalKey principal : this.permissions.getAllPrincipals()) {
            if (this.principalExists(principal)) continue;
            LOG.warn("Principal not found: " + principal);
            valid = false;
        }
        return valid;
    }

    private boolean principalExists(PrincipalKey principal) {
        return this.securityService.getPrincipal(principal).isPresent();
    }

    public void initialize(BeanContext context) {
        this.contentService = (ContentService)context.getService(ContentService.class).get();
        this.securityService = (SecurityService)context.getService(SecurityService.class).get();
    }
}

