/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.ContentIds;
import com.enonic.xp.content.ContentQuery;
import com.enonic.xp.content.Contents;
import com.enonic.xp.content.FindContentIdsByQueryResult;
import com.enonic.xp.content.GetContentByIdsParams;
import com.enonic.xp.lib.common.JsonToFilterMapper;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.QueryAggregationParams;
import com.enonic.xp.lib.content.mapper.ContentsResultMapper;
import com.enonic.xp.query.aggregation.AggregationQuery;
import com.enonic.xp.query.expr.ConstraintExpr;
import com.enonic.xp.query.expr.QueryExpr;
import com.enonic.xp.query.filter.Filter;
import com.enonic.xp.query.filter.Filters;
import com.enonic.xp.query.parser.QueryParser;
import com.enonic.xp.schema.content.ContentTypeNames;
import com.enonic.xp.script.ScriptValue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class QueryContentHandler
extends BaseContextHandler {
    private Integer start;
    private Integer count;
    private String query;
    private String sort;
    private Map<String, Object> aggregations;
    private List<String> contentTypes;
    private List<Map<String, Object>> filters;

    @Override
    protected Object doExecute() {
        int start = this.valueOrDefault(this.start, 0);
        int count = this.valueOrDefault(this.count, 10);
        String query = this.valueOrDefault(this.query, "").trim();
        String sort = this.valueOrDefault(this.sort, "").trim();
        ContentTypeNames contentTypeNames = this.getContentTypeNames();
        List orderExpressions = QueryParser.parseOrderExpressions((String)sort);
        ConstraintExpr constraintExpr = QueryParser.parseCostraintExpression((String)query);
        QueryExpr queryExpr = QueryExpr.from((ConstraintExpr)constraintExpr, (Iterable)orderExpressions);
        Filters filters = JsonToFilterMapper.create(this.filters);
        Set<AggregationQuery> aggregations = new QueryAggregationParams().getAggregations(this.aggregations);
        ContentQuery.Builder queryBuilder = ContentQuery.create().from(start).size(count).aggregationQueries(aggregations).addContentTypeNames(contentTypeNames).queryExpr(queryExpr);
        for (Filter filter : filters) {
            queryBuilder.queryFilter(filter);
        }
        FindContentIdsByQueryResult queryResult = this.contentService.find(queryBuilder.build());
        return this.convert(queryResult);
    }

    private ContentTypeNames getContentTypeNames() {
        if (this.contentTypes == null) {
            return ContentTypeNames.empty();
        }
        return ContentTypeNames.from(this.contentTypes);
    }

    private ContentsResultMapper convert(FindContentIdsByQueryResult findQueryResult) {
        ContentIds contentIds = findQueryResult.getContentIds();
        Contents contents = contentIds.isEmpty() ? Contents.empty() : this.contentService.getByIds(new GetContentByIdsParams(contentIds));
        return new ContentsResultMapper(contents, findQueryResult.getTotalHits(), findQueryResult.getAggregations());
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setAggregations(ScriptValue value) {
        this.aggregations = value != null ? value.getMap() : null;
    }

    public void setContentTypes(ScriptValue value) {
        this.contentTypes = value != null ? value.getArray(String.class) : null;
    }

    public void setFilters(ScriptValue filters) {
        this.filters = this.doSetFilters(filters);
    }

    private List<Map<String, Object>> doSetFilters(ScriptValue filters) {
        ArrayList filterList = Lists.newArrayList();
        if (filters == null) {
            return filterList;
        }
        if (filters.isObject()) {
            filterList.add(filters.getMap());
        } else if (filters.isArray()) {
            filters.getArray().forEach(sv -> {
                if (!sv.isObject()) {
                    throw new IllegalArgumentException("Array elements not of type objects");
                }
                filterList.add(sv.getMap());
            });
        }
        return filterList;
    }
}

