/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.query.aggregation.AggregationQuery;
import com.enonic.xp.query.aggregation.BucketAggregationQuery;
import com.enonic.xp.query.aggregation.DateHistogramAggregationQuery;
import com.enonic.xp.query.aggregation.DateRange;
import com.enonic.xp.query.aggregation.DateRangeAggregationQuery;
import com.enonic.xp.query.aggregation.DistanceRange;
import com.enonic.xp.query.aggregation.GeoDistanceAggregationQuery;
import com.enonic.xp.query.aggregation.HistogramAggregationQuery;
import com.enonic.xp.query.aggregation.NumericRange;
import com.enonic.xp.query.aggregation.NumericRangeAggregationQuery;
import com.enonic.xp.query.aggregation.TermsAggregationQuery;
import com.enonic.xp.query.aggregation.metric.StatsAggregationQuery;
import com.enonic.xp.util.GeoPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

final class QueryAggregationParams {
    QueryAggregationParams() {
    }

    public Set<AggregationQuery> getAggregations(Map<String, Object> aggregationsMap) {
        if (aggregationsMap == null) {
            return Collections.emptySet();
        }
        HashSet<AggregationQuery> aggregations = new HashSet<AggregationQuery>();
        for (String name : aggregationsMap.keySet()) {
            Map aggregationQueryMap;
            AggregationQuery aggregationQuery = this.aggregationQueryFromParams(name, aggregationQueryMap = (Map)aggregationsMap.get(name));
            if (aggregationQuery == null) continue;
            aggregations.add(aggregationQuery);
        }
        return aggregations;
    }

    private AggregationQuery aggregationQueryFromParams(String name, Map<String, Object> aggregationQueryMap) {
        if (aggregationQueryMap.containsKey("terms")) {
            Map termsParamsMap = (Map)aggregationQueryMap.get("terms");
            TermsAggregationQuery.Builder termsAggregationQuery = this.termsAggregationFromParams(name, termsParamsMap);
            this.addSubAggregations((BucketAggregationQuery.Builder)termsAggregationQuery, aggregationQueryMap);
            return termsAggregationQuery.build();
        }
        if (aggregationQueryMap.containsKey("histogram")) {
            Map histogramParamsMap = (Map)aggregationQueryMap.get("histogram");
            HistogramAggregationQuery.Builder termsAggregationQuery = this.histogramAggregationFromParams(name, histogramParamsMap);
            this.addSubAggregations((BucketAggregationQuery.Builder)termsAggregationQuery, aggregationQueryMap);
            return termsAggregationQuery.build();
        }
        if (aggregationQueryMap.containsKey("dateHistogram")) {
            Map dateHistogramParamsMap = (Map)aggregationQueryMap.get("dateHistogram");
            DateHistogramAggregationQuery.Builder dateAggregationQuery = this.dateHistogramAggregationFromParams(name, dateHistogramParamsMap);
            this.addSubAggregations((BucketAggregationQuery.Builder)dateAggregationQuery, aggregationQueryMap);
            return dateAggregationQuery.build();
        }
        if (aggregationQueryMap.containsKey("range")) {
            Map numericRangeParamsMap = (Map)aggregationQueryMap.get("range");
            NumericRangeAggregationQuery.Builder rangeAggregationQuery = this.numericRangeAggregationFromParams(name, numericRangeParamsMap);
            this.addSubAggregations((BucketAggregationQuery.Builder)rangeAggregationQuery, aggregationQueryMap);
            return rangeAggregationQuery.build();
        }
        if (aggregationQueryMap.containsKey("dateRange")) {
            Map dateRangeParamsMap = (Map)aggregationQueryMap.get("dateRange");
            DateRangeAggregationQuery.Builder dateRangeAggregationQuery = this.dateRangeAggregationFromParams(name, dateRangeParamsMap);
            this.addSubAggregations((BucketAggregationQuery.Builder)dateRangeAggregationQuery, aggregationQueryMap);
            return dateRangeAggregationQuery.build();
        }
        if (aggregationQueryMap.containsKey("stats")) {
            Map dateRangeParamsMap = (Map)aggregationQueryMap.get("stats");
            StatsAggregationQuery.Builder statsRangeAggregationQuery = this.statsAggregationFromParams(name, dateRangeParamsMap);
            return statsRangeAggregationQuery.build();
        }
        if (aggregationQueryMap.containsKey("geoDistance")) {
            Map geoDistanceParamsMap = (Map)aggregationQueryMap.get("geoDistance");
            GeoDistanceAggregationQuery.Builder geoDistanceAggregationQuery = this.geoDistanceAggregationFromParams(name, geoDistanceParamsMap);
            return geoDistanceAggregationQuery.build();
        }
        return null;
    }

    private void addSubAggregations(BucketAggregationQuery.Builder aggregationQuery, Map<String, Object> aggregationQueryMap) {
        if (aggregationQueryMap.containsKey("aggregations")) {
            Map aggregationsMap = (Map)aggregationQueryMap.get("aggregations");
            Set<AggregationQuery> aggregation = this.getAggregations(aggregationsMap);
            aggregationQuery.addSubQueries(aggregation);
        }
    }

    private TermsAggregationQuery.Builder termsAggregationFromParams(String name, Map<String, Object> paramsMap) {
        TermsAggregationQuery.Direction orderDirection;
        String fieldName = (String)paramsMap.get("field");
        String orderExpr = ((String)paramsMap.getOrDefault("order", "")).trim();
        int size = (Integer)paramsMap.getOrDefault("size", 10);
        String orderTypeStr = StringUtils.substringBefore((String)orderExpr, (String)" ");
        String orderDir = StringUtils.substringAfter((String)orderExpr, (String)" ");
        TermsAggregationQuery.Direction direction = orderDirection = "desc".equalsIgnoreCase(orderDir) ? TermsAggregationQuery.Direction.DESC : TermsAggregationQuery.Direction.ASC;
        Object orderType = "_term".equals(orderTypeStr) ? TermsAggregationQuery.Type.TERM : ("_count".equals(orderTypeStr) ? TermsAggregationQuery.Type.DOC_COUNT : null);
        return TermsAggregationQuery.create((String)name).fieldName(fieldName).size(Integer.valueOf(size)).orderType(orderType).orderDirection(orderDirection);
    }

    private HistogramAggregationQuery.Builder histogramAggregationFromParams(String name, Map<String, Object> paramsMap) {
        String fieldName = (String)paramsMap.get("field");
        String orderExpr = ((String)paramsMap.getOrDefault("order", "")).trim();
        Long interval = this.getLong(paramsMap, "interval");
        Long extendedBoundMin = this.getLong(paramsMap, "extendedBoundMin");
        Long extendedBoundMax = this.getLong(paramsMap, "extendedBoundMax");
        Long mindDocCount = this.getLong(paramsMap, "minDocCount");
        HistogramAggregationQuery.Order histogramOrder = HistogramAggregationQuery.Order.KEY_ASC;
        if (!orderExpr.isEmpty()) {
            String orderTypeStr = StringUtils.substringBefore((String)orderExpr, (String)" ");
            String orderDir = StringUtils.substringAfter((String)orderExpr, (String)" ");
            if ("_key".equals(orderTypeStr)) {
                histogramOrder = "desc".equalsIgnoreCase(orderDir) ? HistogramAggregationQuery.Order.KEY_DESC : HistogramAggregationQuery.Order.KEY_ASC;
            } else if ("_count".equals(orderTypeStr)) {
                histogramOrder = "desc".equalsIgnoreCase(orderDir) ? HistogramAggregationQuery.Order.COUNT_DESC : HistogramAggregationQuery.Order.COUNT_ASC;
            }
        }
        return ((HistogramAggregationQuery.Builder)((HistogramAggregationQuery.Builder)((HistogramAggregationQuery.Builder)HistogramAggregationQuery.create((String)name).fieldName(fieldName)).interval((Object)interval)).extendedBoundMin(extendedBoundMin.longValue()).extendedBoundMax(extendedBoundMax.longValue()).minDocCount(mindDocCount)).order(histogramOrder);
    }

    private DateHistogramAggregationQuery.Builder dateHistogramAggregationFromParams(String name, Map<String, Object> paramsMap) {
        String fieldName = (String)paramsMap.get("field");
        String interval = (String)paramsMap.getOrDefault("interval", "");
        Long mindDocCount = this.getLong(paramsMap, "minDocCount");
        String format = (String)paramsMap.get("format");
        return ((DateHistogramAggregationQuery.Builder)((DateHistogramAggregationQuery.Builder)((DateHistogramAggregationQuery.Builder)DateHistogramAggregationQuery.create((String)name).fieldName(fieldName)).interval((Object)interval)).minDocCount(mindDocCount)).format(format);
    }

    private NumericRangeAggregationQuery.Builder numericRangeAggregationFromParams(String name, Map<String, Object> paramsMap) {
        String fieldName = (String)paramsMap.get("field");
        List rangeListParams = paramsMap.getOrDefault("ranges", Collections.emptyList());
        ArrayList<NumericRange> ranges = new ArrayList<NumericRange>();
        for (Map rangeParams : rangeListParams) {
            Double from = this.getDouble(rangeParams, "from");
            Double to = this.getDouble(rangeParams, "to");
            String key = rangeParams.getOrDefault("key", null);
            NumericRange range = ((NumericRange.Builder)NumericRange.create().from(from).to(to).key(key)).build();
            ranges.add(range);
        }
        return (NumericRangeAggregationQuery.Builder)((NumericRangeAggregationQuery.Builder)NumericRangeAggregationQuery.create((String)name).fieldName(fieldName)).setRanges(ranges);
    }

    private DateRangeAggregationQuery.Builder dateRangeAggregationFromParams(String name, Map<String, Object> paramsMap) {
        String fieldName = (String)paramsMap.get("field");
        String format = (String)paramsMap.get("format");
        List rangeListParams = paramsMap.getOrDefault("ranges", Collections.emptyList());
        ArrayList<DateRange> ranges = new ArrayList<DateRange>();
        for (Map rangeParams : rangeListParams) {
            String from = rangeParams.getOrDefault("from", null);
            String to = rangeParams.getOrDefault("to", null);
            String key = rangeParams.getOrDefault("key", null);
            DateRange range = ((DateRange.Builder)DateRange.create().from(from).to(to).key(key)).build();
            ranges.add(range);
        }
        return ((DateRangeAggregationQuery.Builder)((DateRangeAggregationQuery.Builder)DateRangeAggregationQuery.create((String)name).fieldName(fieldName)).setRanges(ranges)).format(format);
    }

    private GeoDistanceAggregationQuery.Builder geoDistanceAggregationFromParams(String name, Map<String, Object> params) {
        String fieldName = (String)params.get("field");
        String unit = (String)params.get("unit");
        Map originCoordinates = params.getOrDefault("origin", Collections.emptyMap());
        Double lat = Double.parseDouble((String)originCoordinates.get("lat"));
        Double lon = Double.parseDouble((String)originCoordinates.get("lon"));
        GeoPoint origin = new GeoPoint(lat.doubleValue(), lon.doubleValue());
        List rangeListParams = params.getOrDefault("ranges", Collections.emptyList());
        ArrayList<DistanceRange> ranges = new ArrayList<DistanceRange>();
        for (Map rangeParams : rangeListParams) {
            Double from = rangeParams.getOrDefault("from", null) != null ? Double.valueOf(((Number)rangeParams.getOrDefault("from", null)).doubleValue()) : null;
            Double to = rangeParams.getOrDefault("to", null) != null ? Double.valueOf(((Number)rangeParams.getOrDefault("to", null)).doubleValue()) : null;
            String key = rangeParams.getOrDefault("key", null);
            DistanceRange range = ((DistanceRange.Builder)DistanceRange.create().from(from).to(to).key(key)).build();
            ranges.add(range);
        }
        return (GeoDistanceAggregationQuery.Builder)((GeoDistanceAggregationQuery.Builder)GeoDistanceAggregationQuery.create((String)name).fieldName(fieldName)).origin(origin).unit(unit).setRanges(ranges);
    }

    private StatsAggregationQuery.Builder statsAggregationFromParams(String name, Map<String, Object> paramsMap) {
        String fieldName = (String)paramsMap.get("field");
        return (StatsAggregationQuery.Builder)StatsAggregationQuery.create((String)name).fieldName(fieldName);
    }

    private Long getLong(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value != null && value instanceof Number ? Long.valueOf(((Number)value).longValue()) : null;
    }

    private Double getDouble(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return value != null && value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : null;
    }
}

