/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.branch.Branch;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentIds;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.ContentPublishInfo;
import com.enonic.xp.content.ContentService;
import com.enonic.xp.content.PublishContentResult;
import com.enonic.xp.content.PushContentParams;
import com.enonic.xp.context.Context;
import com.enonic.xp.context.ContextAccessor;
import com.enonic.xp.context.ContextBuilder;
import com.enonic.xp.lib.content.mapper.PushContentResultMapper;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;

public final class PublishContentHandler
implements ScriptBean {
    private String[] keys;
    private String targetBranch;
    private String sourceBranch;
    private Map<String, Object> contentPublishInfo;
    private String[] excludeChildrenIds;
    private Boolean includeChildren;
    private Boolean includeDependencies;
    private ContentService contentService;

    public PushContentResultMapper execute() {
        Context context = ContextBuilder.from((Context)ContextAccessor.current()).branch(this.sourceBranch).build();
        return (PushContentResultMapper)context.callWith(this::publishContent);
    }

    private PushContentResultMapper publishContent() {
        PublishContentResult result;
        ArrayList<ContentPath> contentNotFound = new ArrayList<ContentPath>();
        ArrayList<ContentId> contentIds = new ArrayList<ContentId>();
        for (String key : this.keys) {
            if (key.startsWith("/")) {
                ContentPath path = ContentPath.from((String)key);
                Content content = this.getByPath(path);
                if (content != null) {
                    contentIds.add(content.getId());
                    continue;
                }
                contentNotFound.add(path);
                continue;
            }
            contentIds.add(ContentId.from((String)key));
        }
        PushContentParams.Builder builder = PushContentParams.create();
        builder.contentIds(ContentIds.from(contentIds));
        builder.target(Branch.from((String)this.targetBranch));
        if (this.contentPublishInfo != null) {
            Object from = this.contentPublishInfo.get("from");
            Object to = this.contentPublishInfo.get("to");
            ContentPublishInfo contentPublishInfo = ContentPublishInfo.create().from(from == null ? null : Instant.parse((String)from)).to(to == null ? null : Instant.parse((String)to)).build();
            builder.contentPublishInfo(contentPublishInfo);
        }
        if (this.excludeChildrenIds != null) {
            builder.excludeChildrenIds(ContentIds.from((String[])this.excludeChildrenIds));
        }
        if (this.includeChildren != null) {
            builder.includeChildren(this.includeChildren.booleanValue());
        }
        if (this.includeDependencies != null) {
            builder.includeDependencies(this.includeDependencies.booleanValue());
        }
        return (result = this.contentService.publish(builder.build())) != null ? new PushContentResultMapper(result, contentNotFound) : null;
    }

    private Content getByPath(ContentPath contentPath) {
        try {
            return this.contentService.getByPath(contentPath);
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void setTargetBranch(String targetBranch) {
        this.targetBranch = targetBranch;
    }

    public void setSourceBranch(String sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public void setExcludeChildrenIds(String[] excludeChildrenIds) {
        this.excludeChildrenIds = excludeChildrenIds;
    }

    public void setIncludeChildren(Boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    public void setIncludeDependencies(Boolean includeDependencies) {
        this.includeDependencies = includeDependencies;
    }

    public void setContentPublishInfo(ScriptValue contentPublishInfo) {
        this.contentPublishInfo = contentPublishInfo != null ? contentPublishInfo.getMap() : null;
    }

    public void initialize(BeanContext context) {
        this.contentService = (ContentService)context.getService(ContentService.class).get();
    }
}

