/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentAlreadyExistsException;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentName;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.MoveContentParams;
import com.enonic.xp.content.MoveContentsResult;
import com.enonic.xp.content.RenameContentParams;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.ContentMapper;
import java.util.UUID;

public final class MoveContentHandler
extends BaseContextHandler {
    private String source;
    private String target;

    @Override
    protected Object doExecute() {
        return this.convert(this.executeMove());
    }

    private Content executeMove() {
        ContentId sourceId;
        Content sourceContent;
        ContentPath sourcePath;
        if (this.source.startsWith("/")) {
            sourcePath = ContentPath.from((String)this.source);
            sourceContent = this.contentService.getByPath(sourcePath);
            sourceId = sourceContent.getId();
        } else {
            sourceId = ContentId.from((String)this.source);
            sourceContent = this.contentService.getById(sourceId);
            sourcePath = sourceContent.getPath();
        }
        if (this.target.endsWith("/")) {
            return this.move(sourceId, ContentPath.from((String)this.target).asAbsolute());
        }
        if (!this.target.startsWith("/")) {
            return this.rename(sourceId, this.target);
        }
        ContentPath targetPath = ContentPath.from((String)this.target);
        ContentPath targetParent = targetPath.getParentPath();
        if (targetParent.equals((Object)sourcePath.getParentPath())) {
            return this.rename(sourceId, targetPath.getName());
        }
        if (this.contentService.contentExists(targetPath)) {
            throw new ContentAlreadyExistsException(targetPath);
        }
        this.rename(sourceId, this.uniqueName());
        this.move(sourceId, targetParent);
        return this.rename(sourceId, targetPath.getName());
    }

    private ContentMapper convert(Content content) {
        return new ContentMapper(content);
    }

    private Content move(ContentId sourceId, ContentPath newPath) {
        MoveContentParams moveParams = MoveContentParams.create().contentId(sourceId).parentContentPath(newPath).build();
        MoveContentsResult result = this.contentService.move(moveParams);
        return this.contentService.getById((ContentId)result.getMovedContents().first());
    }

    private Content rename(ContentId sourceId, String newName) {
        ContentName newContentName = ContentName.from((String)newName);
        RenameContentParams renameParams = RenameContentParams.create().contentId(sourceId).newName(newContentName).build();
        return this.contentService.rename(renameParams);
    }

    private String uniqueName() {
        return UUID.randomUUID().toString();
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

