/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentEditor;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.ContentPublishInfo;
import com.enonic.xp.content.EditableContent;
import com.enonic.xp.content.ExtraData;
import com.enonic.xp.content.ExtraDatas;
import com.enonic.xp.content.UpdateContentParams;
import com.enonic.xp.convert.Converters;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.ContentMapper;
import com.enonic.xp.schema.content.ContentTypeName;
import com.enonic.xp.schema.xdata.XDataName;
import com.enonic.xp.script.ScriptValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Map;

public final class ModifyContentHandler
extends BaseContextHandler {
    private String key;
    private ScriptValue editor;
    private boolean requireValid = true;

    @Override
    protected Object doExecute() {
        Content existingContent = this.getExistingContent(this.key);
        if (existingContent == null) {
            return null;
        }
        UpdateContentParams params = new UpdateContentParams();
        params.contentId(existingContent.getId());
        params.editor(this.newContentEditor(existingContent));
        params.requireValid(this.requireValid);
        Content result = this.contentService.update(params);
        return result != null ? new ContentMapper(result) : null;
    }

    private Content getExistingContent(String key) {
        try {
            if (!key.startsWith("/")) {
                return this.contentService.getById(ContentId.from((String)key));
            }
            return this.contentService.getByPath(ContentPath.from((String)key));
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    private ContentEditor newContentEditor(Content existingContent) {
        return edit -> {
            ScriptValue value = this.editor.call(new Object[]{new ContentMapper(edit.source)});
            if (value != null) {
                this.updateContent(edit, value.getMap(), existingContent);
            }
        };
    }

    private void updateContent(EditableContent target, Map<?, ?> map, Content existingContent) {
        Object publishInfo;
        Object extraData;
        Object data;
        String languageCode;
        String displayName = (String)Converters.convert(map.get("displayName"), String.class);
        if (displayName != null) {
            target.displayName = displayName;
        }
        if ((languageCode = (String)Converters.convert(map.get("language"), String.class)) != null) {
            target.language = Locale.forLanguageTag(languageCode);
        }
        if ((data = map.get("data")) instanceof Map) {
            target.data = this.createPropertyTree((Map)data, existingContent.getType());
        }
        if ((extraData = map.get("x")) instanceof Map) {
            target.extraDatas = this.createExtraDatas((Map)extraData, existingContent.getType());
        }
        if ((publishInfo = map.get("publish")) instanceof Map) {
            target.publishInfo = this.createContentPublishInfo((Map)publishInfo);
        }
    }

    private ContentPublishInfo createContentPublishInfo(Map<String, Object> value) {
        if (value == null) {
            return null;
        }
        return ContentPublishInfo.create().from(this.getInstant(value, "from")).to(this.getInstant(value, "to")).build();
    }

    private Instant getInstant(Map<String, Object> valueMap, String key) {
        Object value = valueMap.get(key);
        if (value != null) {
            try {
                return Instant.parse(value.toString());
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException(key + " value could not be parsed to instant: [" + value + "]");
            }
        }
        return null;
    }

    private PropertyTree createPropertyTree(Map<?, ?> value, ContentTypeName contentTypeName) {
        if (value == null) {
            return null;
        }
        return this.translateToPropertyTree(this.createJson(value), contentTypeName);
    }

    private PropertyTree createPropertyTree(Map<?, ?> value, XDataName xDataName, ContentTypeName contentTypeName) {
        if (value == null) {
            return null;
        }
        return this.translateToPropertyTree(this.createJson(value), xDataName, contentTypeName);
    }

    private JsonNode createJson(Map<?, ?> value) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.valueToTree(value);
    }

    private ExtraDatas createExtraDatas(Map<String, Object> value, ContentTypeName contentTypeName) {
        if (value == null) {
            return null;
        }
        ExtraDatas.Builder extradatasBuilder = ExtraDatas.create();
        for (String applicationPrefix : value.keySet()) {
            ApplicationKey applicationKey = ExtraData.fromApplicationPrefix((String)applicationPrefix);
            Object metadatasObject = value.get(applicationPrefix);
            if (!(metadatasObject instanceof Map)) continue;
            Map metadatas = (Map)metadatasObject;
            for (String metadataName : metadatas.keySet()) {
                XDataName xDataName = XDataName.from((ApplicationKey)applicationKey, (String)metadataName);
                ExtraData item = this.createExtraData(xDataName, contentTypeName, metadatas.get(metadataName));
                if (item == null) continue;
                extradatasBuilder.add(item);
            }
        }
        return extradatasBuilder.build();
    }

    private ExtraData createExtraData(XDataName xDataName, ContentTypeName contentTypeName, Object value) {
        PropertyTree propertyTree;
        if (value instanceof Map && (propertyTree = this.createPropertyTree((Map)value, xDataName, contentTypeName)) != null) {
            return new ExtraData(xDataName, propertyTree);
        }
        return null;
    }

    @Override
    protected boolean strictDataValidation() {
        return this.requireValid;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setEditor(ScriptValue editor) {
        this.editor = editor;
    }

    public void setRequireValid(Boolean requireValid) {
        if (requireValid != null) {
            this.requireValid = requireValid;
        }
    }
}

