/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.SiteMapper;
import com.enonic.xp.site.Site;

public final class GetSiteHandler
extends BaseContextHandler {
    private String key;

    @Override
    protected Object doExecute() {
        if (this.key == null || this.key.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'key' is required");
        }
        if (this.key.startsWith("/")) {
            return this.getByPath(ContentPath.from((String)this.key));
        }
        return this.getById(ContentId.from((String)this.key));
    }

    private SiteMapper getByPath(ContentPath contentPath) {
        try {
            Content content = this.contentService.getByPath(contentPath);
            return this.getById(content.getId());
        }
        catch (ContentNotFoundException contentNotFoundException) {
            return null;
        }
    }

    private SiteMapper getById(ContentId contentId) {
        try {
            Site site = this.contentService.getNearestSite(contentId);
            if (site != null) {
                return this.convert(site);
            }
        }
        catch (ContentNotFoundException contentNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private SiteMapper convert(Site content) {
        return new SiteMapper(content);
    }

    public void setKey(String key) {
        this.key = key;
    }
}

