/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.site.Site;

public final class GetSiteConfigHandler
extends BaseContextHandler {
    private String key;
    private String applicationKey;

    @Override
    protected Object doExecute() {
        if (this.key == null || this.key.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'key' is required");
        }
        if (this.key.startsWith("/")) {
            return this.getByPath(ContentPath.from((String)this.key));
        }
        return this.getById(ContentId.from((String)this.key));
    }

    private PropertyTreeMapper getByPath(ContentPath contentPath) {
        try {
            Content content = this.contentService.getByPath(contentPath);
            return this.getById(content.getId());
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    private PropertyTreeMapper getById(ContentId contentId) {
        try {
            PropertyTree siteConfigPropertyTree;
            Site site = this.contentService.getNearestSite(contentId);
            if (site != null && this.applicationKey != null && (siteConfigPropertyTree = site.getSiteConfig(ApplicationKey.from((String)this.applicationKey))) != null) {
                return new PropertyTreeMapper(siteConfigPropertyTree);
            }
        }
        catch (ContentNotFoundException contentNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }
}

