/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.ContentMapper;

public final class GetContentHandler
extends BaseContextHandler {
    private String key;

    @Override
    protected Object doExecute() {
        if (this.key.startsWith("/")) {
            return this.getByPath(ContentPath.from((String)this.key));
        }
        return this.getById(ContentId.from((String)this.key));
    }

    private ContentMapper getByPath(ContentPath key) {
        try {
            return this.convert(this.contentService.getByPath(key));
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    private ContentMapper getById(ContentId key) {
        try {
            return this.convert(this.contentService.getById(key));
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    private ContentMapper convert(Content content) {
        return new ContentMapper(content);
    }

    public void setKey(String key) {
        this.key = key;
    }
}

