/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.Contents;
import com.enonic.xp.content.FindContentByParentParams;
import com.enonic.xp.content.FindContentByParentResult;
import com.enonic.xp.index.ChildOrder;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.ContentsResultMapper;

public final class GetChildContentHandler
extends BaseContextHandler {
    static final int DEFAULT_COUNT = 10;
    private String key;
    private Integer start;
    private Integer count;
    private String sort;

    @Override
    protected Object doExecute() {
        int start = this.valueOrDefault(this.start, 0);
        int count = this.valueOrDefault(this.count, 10);
        String sortExpr = this.valueOrDefault(this.sort, "");
        FindContentByParentParams.Builder findContentByParent = FindContentByParentParams.create();
        if (this.key.startsWith("/")) {
            findContentByParent.parentPath(ContentPath.from((String)this.key));
        } else {
            findContentByParent.parentId(ContentId.from((String)this.key));
        }
        return this.getChildren(findContentByParent, start, count, sortExpr);
    }

    private ContentsResultMapper getChildren(FindContentByParentParams.Builder findContentByParent, int start, int count, String sortExpr) {
        ChildOrder childOrder = ChildOrder.from((String)sortExpr);
        try {
            FindContentByParentResult result = this.contentService.findByParent(findContentByParent.from(Integer.valueOf(start)).size(Integer.valueOf(count)).childOrder(childOrder).build());
            return this.convert(result);
        }
        catch (ContentNotFoundException e) {
            return new ContentsResultMapper(Contents.empty(), 0L);
        }
    }

    private ContentsResultMapper convert(FindContentByParentResult findContentResult) {
        return new ContentsResultMapper(findContentResult.getContents(), findContentResult.getTotalHits());
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
}

