/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.attachment.Attachment;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.ContentService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.google.common.io.ByteSource;

public final class GetAttachmentStreamHandler
implements ScriptBean {
    private ContentService contentService;
    private String key;
    private String name;

    public ByteSource getStream() {
        if (this.key.startsWith("/")) {
            return this.getByPath(ContentPath.from((String)this.key));
        }
        return this.getById(ContentId.from((String)this.key));
    }

    private ByteSource getByPath(ContentPath key) {
        try {
            return this.getAttachment(this.contentService.getByPath(key), this.name);
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    private ByteSource getById(ContentId key) {
        try {
            return this.getAttachment(this.contentService.getById(key), this.name);
        }
        catch (ContentNotFoundException e) {
            return null;
        }
    }

    private ByteSource getAttachment(Content content, String attachmentName) {
        Attachment attachment = content.getAttachments().byName(attachmentName);
        if (attachment == null) {
            return null;
        }
        return this.contentService.getBinary(content.getId(), attachment.getBinaryReference());
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialize(BeanContext context) {
        this.contentService = (ContentService)context.getService(ContentService.class).get();
    }
}

