/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentConstants;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentNotFoundException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.DeleteContentParams;
import com.enonic.xp.context.ContextAccessor;
import com.enonic.xp.lib.content.BaseContextHandler;

public final class DeleteContentHandler
extends BaseContextHandler {
    private String key;

    @Override
    protected Object doExecute() {
        if (this.key.startsWith("/")) {
            return this.deleteByPath(ContentPath.from((String)this.key));
        }
        return this.deleteById(ContentId.from((String)this.key));
    }

    private boolean deleteById(ContentId id) {
        try {
            Content content = this.contentService.getById(id);
            return this.deleteByPath(content.getPath());
        }
        catch (ContentNotFoundException e) {
            return false;
        }
    }

    private boolean deleteByPath(ContentPath path) {
        DeleteContentParams params = DeleteContentParams.create().contentPath(path).deleteOnline(this.isMasterBranch()).build();
        return this.doDelete(params);
    }

    private boolean doDelete(DeleteContentParams params) {
        try {
            return this.contentService.deleteWithoutFetch(params) != null;
        }
        catch (ContentNotFoundException e) {
            return false;
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    private boolean isMasterBranch() {
        return ContextAccessor.current().getBranch().equals((Object)ContentConstants.BRANCH_MASTER);
    }
}

