/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentAlreadyExistsException;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.CreateMediaParams;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.ContentMapper;
import com.google.common.io.ByteSource;
import java.security.SecureRandom;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;

public final class CreateMediaHandler
extends BaseContextHandler {
    private static final Random RANDOM = new SecureRandom();
    private String name;
    private String parentPath;
    private ByteSource data;
    private String mimeType;
    private double focalX = 0.5;
    private double focalY = 0.5;
    private Supplier<String> idGenerator = () -> Long.toString(Math.abs(RANDOM.nextLong()));

    @Override
    protected Object doExecute() {
        ContentPath parent;
        String name = this.name;
        Content result = null;
        ContentPath contentPath = parent = this.parentPath != null ? ContentPath.from((String)this.parentPath) : ContentPath.ROOT;
        while (result == null) {
            CreateMediaParams params = this.createParams(name);
            try {
                result = this.contentService.create(params);
            }
            catch (ContentAlreadyExistsException e) {
                name = this.generateUniqueContentName(this.idGenerator, parent, this.name);
            }
        }
        return new ContentMapper(result);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void setData(ByteSource data) {
        this.data = data;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setFocalX(double focalX) {
        this.focalX = focalX;
    }

    public void setFocalY(double focalY) {
        this.focalY = focalY;
    }

    public void setIdGenerator(Supplier<String> idGenerator) {
        if (idGenerator != null) {
            this.idGenerator = idGenerator;
        }
    }

    private CreateMediaParams createParams(String name) {
        CreateMediaParams params = new CreateMediaParams();
        params.name(name);
        params.parent(this.parentPath != null ? ContentPath.from((String)this.parentPath) : null);
        params.mimeType(this.mimeType);
        params.byteSource(this.data);
        params.focalX(this.focalX);
        params.focalY(this.focalY);
        return params;
    }

    protected String generateUniqueContentName(Supplier<String> idGenerator, ContentPath parent, String baseName) {
        Object name = baseName;
        while (this.contentService.contentExists(ContentPath.from((ContentPath)parent, (String)name))) {
            String randomId = idGenerator.get();
            if (baseName.contains(".")) {
                String fileName = StringUtils.substringBeforeLast((String)baseName, (String)".");
                String ext = StringUtils.substringAfterLast((String)baseName, (String)".");
                name = fileName + "-" + randomId + "." + ext;
                continue;
            }
            name = baseName + "-" + randomId;
        }
        return name;
    }
}

