/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.CreateContentParams;
import com.enonic.xp.content.ExtraData;
import com.enonic.xp.content.ExtraDatas;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.index.ChildOrder;
import com.enonic.xp.lib.content.BaseContextHandler;
import com.enonic.xp.lib.content.mapper.ContentMapper;
import com.enonic.xp.name.NamePrettyfier;
import com.enonic.xp.schema.content.ContentTypeName;
import com.enonic.xp.schema.xdata.XDataName;
import com.enonic.xp.script.ScriptValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;

public final class CreateContentHandler
extends BaseContextHandler {
    private static final Random RANDOM = new SecureRandom();
    private String name;
    private String parentPath;
    private String displayName;
    private boolean requireValid = true;
    private boolean refresh = true;
    private Map<String, Object> data;
    private Map<String, Object> x;
    private String contentType;
    private String language;
    private String childOrder;
    private Supplier<String> idGenerator = () -> Long.toString(Math.abs(RANDOM.nextLong()));

    @Override
    protected Object doExecute() {
        if (StringUtils.isBlank((String)this.name) && StringUtils.isNotBlank((String)this.displayName) && StringUtils.isNotBlank((String)this.parentPath)) {
            this.name = this.generateUniqueContentName(ContentPath.from((String)this.parentPath), this.displayName);
        }
        if (StringUtils.isBlank((String)this.displayName) && StringUtils.isNotBlank((String)this.name)) {
            this.displayName = this.name;
        }
        CreateContentParams params = this.createParams();
        Content result = this.contentService.create(params);
        return new ContentMapper(result);
    }

    private CreateContentParams createParams() {
        ContentTypeName contentTypeName = this.contentTypeName(this.contentType);
        return CreateContentParams.create().name(this.name).parent(this.contentPath(this.parentPath)).displayName(this.displayName).requireValid(this.requireValid).type(contentTypeName).contentData(this.createPropertyTree(this.data, contentTypeName)).extraDatas(this.createExtraDatas(this.x, contentTypeName)).language(this.language != null ? Locale.forLanguageTag(this.language) : null).childOrder(this.childOrder != null ? ChildOrder.from((String)this.childOrder) : null).refresh(this.refresh).build();
    }

    private ContentPath contentPath(String value) {
        return value != null ? ContentPath.from((String)value) : null;
    }

    private ContentTypeName contentTypeName(String value) {
        return value != null ? ContentTypeName.from((String)value) : null;
    }

    private PropertyTree createPropertyTree(Map<?, ?> value, ContentTypeName contentTypeName) {
        if (value == null) {
            return null;
        }
        return this.translateToPropertyTree(this.createJson(value), contentTypeName);
    }

    private PropertyTree createPropertyTree(Map<?, ?> value, XDataName xDataName, ContentTypeName contentTypeName) {
        if (value == null) {
            return null;
        }
        return this.translateToPropertyTree(this.createJson(value), xDataName, contentTypeName);
    }

    private JsonNode createJson(Map<?, ?> value) {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.valueToTree(value);
    }

    private ExtraDatas createExtraDatas(Map<String, Object> value, ContentTypeName contentTypeName) {
        if (value == null) {
            return null;
        }
        ExtraDatas.Builder extradatasBuilder = ExtraDatas.create();
        for (String applicationPrefix : value.keySet()) {
            ApplicationKey applicationKey = ExtraData.fromApplicationPrefix((String)applicationPrefix);
            Object extradatasObject = value.get(applicationPrefix);
            if (!(extradatasObject instanceof Map)) continue;
            Map extradatas = (Map)extradatasObject;
            for (Map.Entry entry : extradatas.entrySet()) {
                XDataName xDataName = XDataName.from((ApplicationKey)applicationKey, (String)entry.getKey().toString());
                ExtraData item = this.createExtraData(xDataName, contentTypeName, entry.getValue());
                if (item == null) continue;
                extradatasBuilder.add(item);
            }
        }
        return extradatasBuilder.build();
    }

    private ExtraData createExtraData(XDataName xDataName, ContentTypeName contentTypeName, Object value) {
        if (value instanceof Map) {
            PropertyTree tree = this.createPropertyTree((Map)value, xDataName, contentTypeName);
            return tree != null ? new ExtraData(xDataName, tree) : null;
        }
        return null;
    }

    private String generateUniqueContentName(ContentPath parent, String displayName) {
        String baseName;
        String name = baseName = NamePrettyfier.create((String)displayName);
        while (this.contentService.contentExists(ContentPath.from((ContentPath)parent, (String)name))) {
            String randomId = this.idGenerator.get();
            name = NamePrettyfier.create((String)(baseName + "-" + randomId));
        }
        return name;
    }

    @Override
    protected boolean strictDataValidation() {
        return this.requireValid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setRequireValid(Boolean requireValid) {
        if (requireValid != null) {
            this.requireValid = requireValid;
        }
    }

    public void setRefresh(Boolean refresh) {
        if (refresh != null) {
            this.refresh = refresh;
        }
    }

    public void setData(ScriptValue data) {
        this.data = data != null ? data.getMap() : null;
    }

    public void setX(ScriptValue x) {
        this.x = x != null ? x.getMap() : null;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setChildOrder(String childOrder) {
        this.childOrder = childOrder;
    }

    public void setIdGenerator(Supplier<String> idGenerator) {
        if (idGenerator != null) {
            this.idGenerator = idGenerator;
        }
    }
}

