/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.form.Form;
import com.enonic.xp.lib.content.mapper.ContentTypeMapper;
import com.enonic.xp.schema.content.ContentType;
import com.enonic.xp.schema.content.ContentTypeName;
import com.enonic.xp.schema.content.ContentTypeService;
import com.enonic.xp.schema.content.ContentTypes;
import com.enonic.xp.schema.content.GetContentTypeParams;
import com.enonic.xp.schema.mixin.MixinService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ContentTypeHandler
implements ScriptBean {
    private Supplier<ContentTypeService> contentTypeService;
    private Supplier<MixinService> mixinService;
    private String name;

    public ContentTypeMapper getContentType() {
        if (this.name == null || this.name.trim().isEmpty()) {
            return null;
        }
        GetContentTypeParams params = GetContentTypeParams.from((ContentTypeName)ContentTypeName.from((String)this.name));
        ContentType ctype = this.contentTypeService.get().getByName(params);
        return ctype == null ? null : new ContentTypeMapper(this.inlineMixins(ctype));
    }

    public List<ContentTypeMapper> getAllContentTypes() {
        ContentTypes types = this.contentTypeService.get().getAll();
        return types.stream().map(this::inlineMixins).map(ContentTypeMapper::new).collect(Collectors.toList());
    }

    private ContentType inlineMixins(ContentType contentType) {
        ContentType.Builder ctInlined = ContentType.create((ContentType)contentType);
        Form inlinedForm = this.mixinService.get().inlineFormItems(contentType.getForm());
        if (inlinedForm == null) {
            return contentType;
        }
        return ctInlined.form(inlinedForm).build();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialize(BeanContext context) {
        this.contentTypeService = context.getService(ContentTypeService.class);
        this.mixinService = context.getService(MixinService.class);
    }
}

