/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.content.ContentService;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.form.Form;
import com.enonic.xp.lib.common.FormJsonToPropertyTreeTranslator;
import com.enonic.xp.schema.content.ContentType;
import com.enonic.xp.schema.content.ContentTypeName;
import com.enonic.xp.schema.content.ContentTypeService;
import com.enonic.xp.schema.content.GetContentTypeParams;
import com.enonic.xp.schema.mixin.MixinService;
import com.enonic.xp.schema.xdata.XData;
import com.enonic.xp.schema.xdata.XDataName;
import com.enonic.xp.schema.xdata.XDataService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.fasterxml.jackson.databind.JsonNode;

public abstract class BaseContextHandler
implements ScriptBean {
    protected ContentService contentService;
    private ContentTypeService contentTypeService;
    private MixinService mixinService;
    private XDataService xDataService;

    public final Object execute() {
        return this.doExecute();
    }

    protected abstract Object doExecute();

    protected <T> T valueOrDefault(T value, T defValue) {
        return value == null ? defValue : value;
    }

    protected boolean strictDataValidation() {
        return true;
    }

    private boolean strictContentValidation(ContentTypeName contentTypeName) {
        return !contentTypeName.isUnstructured() && this.strictDataValidation();
    }

    protected PropertyTree translateToPropertyTree(JsonNode json, ContentTypeName contentTypeName) {
        ContentType contentType = this.contentTypeService.getByName(GetContentTypeParams.from((ContentTypeName)contentTypeName));
        if (contentType == null) {
            throw new IllegalArgumentException("Content type not found [" + contentTypeName + "]");
        }
        return new FormJsonToPropertyTreeTranslator(this.inlineMixins(contentType.getForm()), this.strictContentValidation(contentTypeName)).translate(json);
    }

    protected PropertyTree translateToPropertyTree(JsonNode json, XDataName xDataName, ContentTypeName contentTypeName) {
        XData xData = this.xDataService.getByName(xDataName);
        if (xData == null) {
            throw new IllegalArgumentException("XData not found [" + xDataName + "]");
        }
        return new FormJsonToPropertyTreeTranslator(this.inlineMixins(xData.getForm()), this.strictContentValidation(contentTypeName)).translate(json);
    }

    private Form inlineMixins(Form form) {
        return this.mixinService.inlineFormItems(form);
    }

    public void initialize(BeanContext context) {
        this.contentService = (ContentService)context.getService(ContentService.class).get();
        this.contentTypeService = (ContentTypeService)context.getService(ContentTypeService.class).get();
        this.mixinService = (MixinService)context.getService(MixinService.class).get();
        this.xDataService = (XDataService)context.getService(XDataService.class).get();
    }
}

