/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.content;

import com.enonic.xp.attachment.CreateAttachment;
import com.enonic.xp.attachment.CreateAttachments;
import com.enonic.xp.content.Content;
import com.enonic.xp.content.ContentId;
import com.enonic.xp.content.ContentPath;
import com.enonic.xp.content.ContentService;
import com.enonic.xp.content.UpdateContentParams;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;

public final class AddAttachmentHandler
implements ScriptBean {
    private ContentService contentService;
    private String key;
    private String name;
    private String mimeType;
    private String label;
    private Object data;

    public void execute() {
        UpdateContentParams updateContent = new UpdateContentParams();
        if (!this.key.startsWith("/")) {
            updateContent.contentId(ContentId.from((String)this.key));
        } else {
            Content contentByPath = this.contentService.getByPath(ContentPath.from((String)this.key));
            updateContent.contentId(contentByPath.getId());
        }
        CreateAttachment createAttachment = CreateAttachment.create().name(this.name).label(this.label).mimeType(this.mimeType).byteSource(this.getData()).build();
        updateContent.createAttachments(CreateAttachments.from((CreateAttachment[])new CreateAttachment[]{createAttachment}));
        this.contentService.update(updateContent);
    }

    private ByteSource getData() {
        if (this.data instanceof ByteSource) {
            return (ByteSource)this.data;
        }
        if (this.data instanceof String) {
            return ByteSource.wrap((byte[])((String)this.data).getBytes(StandardCharsets.UTF_8));
        }
        return ByteSource.wrap((byte[])this.data.toString().getBytes(StandardCharsets.UTF_8));
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void initialize(BeanContext context) {
        this.contentService = (ContentService)context.getService(ContentService.class).get();
    }
}

