/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.common;

import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import java.util.List;
import java.util.Map;

public final class PropertyTreeMapper
implements MapSerializable {
    private final PropertyTree value;
    private final boolean useRawValue;

    public PropertyTreeMapper(PropertyTree value) {
        this.value = value;
        this.useRawValue = false;
    }

    public PropertyTreeMapper(boolean useRawValue, PropertyTree value) {
        this.useRawValue = useRawValue;
        this.value = value;
    }

    public void serialize(MapGenerator gen) {
        this.serialize(gen, this.value);
    }

    private void serialize(MapGenerator gen, PropertyTree value) {
        Map map = value.toMap();
        this.serializeMap(gen, map);
    }

    private void serializeMap(MapGenerator gen, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.serializeKeyValue(gen, entry.getKey().toString(), entry.getValue());
        }
    }

    private void serializeKeyValue(MapGenerator gen, String key, Object value) {
        if (value instanceof List) {
            this.serializeList(gen, key, (List)value);
        } else if (value instanceof Map) {
            this.serializeMap(gen, key, (Map)value);
        } else if (this.useRawValue) {
            gen.rawValue(key, value);
        } else {
            gen.value(key, value);
        }
    }

    private void serializeList(MapGenerator gen, String key, List<?> values) {
        if (values.isEmpty()) {
            this.serializeKeyValue(gen, key, null);
            return;
        }
        if (values.size() == 1) {
            this.serializeKeyValue(gen, key, values.get(0));
            return;
        }
        gen.array(key);
        for (Object value : values) {
            this.serializeValue(gen, value);
        }
        gen.end();
    }

    private void serializeMap(MapGenerator gen, String key, Map<?, ?> map) {
        gen.map(key);
        this.serializeMap(gen, map);
        gen.end();
    }

    private void serializeValue(MapGenerator gen, Object value) {
        if (value instanceof Map) {
            gen.map();
            this.serializeMap(gen, (Map)value);
            gen.end();
        } else if (this.useRawValue) {
            gen.rawValue(value);
        } else {
            gen.value(value);
        }
    }
}

