/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.common;

import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.lib.common.PropertyTreeMapper;
import com.enonic.xp.script.serializer.MapGenerator;
import com.enonic.xp.script.serializer.MapSerializable;
import com.enonic.xp.security.Principal;
import com.enonic.xp.security.User;

public final class PrincipalMapper
implements MapSerializable {
    private final Principal value;
    private final boolean detailed;

    public PrincipalMapper(Principal value) {
        this(value, false);
    }

    public PrincipalMapper(Principal value, boolean detailed) {
        this.value = value;
        this.detailed = detailed;
    }

    private void serialize(MapGenerator gen, Principal value) {
        gen.value("type", (Object)value.getClass().getSimpleName().toLowerCase());
        gen.value("key", (Object)value.getKey());
        gen.value("displayName", (Object)value.getDisplayName());
        gen.value("modifiedTime", (Object)value.getModifiedTime());
        if (value instanceof User) {
            User user = (User)value;
            gen.value("disabled", (Object)user.isDisabled());
            gen.value("email", (Object)user.getEmail());
            gen.value("login", (Object)user.getLogin());
            gen.value("idProvider", value.getKey() != null ? value.getKey().getIdProviderKey() : null);
            this.serializeProfile(gen, user.getProfile());
        } else {
            gen.value("description", (Object)value.getDescription());
        }
    }

    private void serializeProfile(MapGenerator gen, PropertyTree value) {
        if (this.detailed) {
            gen.map("profile");
            new PropertyTreeMapper(value).serialize(gen);
            gen.end();
        }
    }

    public void serialize(MapGenerator gen) {
        this.serialize(gen, this.value);
    }
}

