/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.common;

import com.enonic.xp.data.PropertySet;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.data.Value;
import com.enonic.xp.data.ValueFactory;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.Map;

public final class JsonToPropertyTreeTranslator {
    public static PropertyTree translate(JsonNode json) {
        PropertyTree propertyTree = new PropertyTree();
        JsonToPropertyTreeTranslator.traverse(json, propertyTree.getRoot());
        return propertyTree;
    }

    private static void traverse(JsonNode json, PropertySet parent) {
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            JsonToPropertyTreeTranslator.addValue(parent, (String)next.getKey(), (JsonNode)next.getValue());
        }
    }

    private static void addValue(PropertySet parent, String key, JsonNode value) {
        if (value.isArray()) {
            for (JsonNode objNode : value) {
                JsonToPropertyTreeTranslator.addValue(parent, key, objNode);
            }
        } else if (value.isObject()) {
            PropertySet parentSet = parent.addSet(key);
            value.fields().forEachRemaining(objectValue -> JsonToPropertyTreeTranslator.addValue(parentSet, (String)objectValue.getKey(), (JsonNode)objectValue.getValue()));
        } else {
            JsonToPropertyTreeTranslator.mapValue(parent, key, value);
        }
    }

    private static void mapValue(PropertySet parent, String key, JsonNode value) {
        parent.addProperty(key, JsonToPropertyTreeTranslator.resolveCoreValue(value));
    }

    private static Value resolveCoreValue(JsonNode value) {
        if (value.isDouble()) {
            return ValueFactory.newDouble((Double)value.doubleValue());
        }
        if (value.isTextual()) {
            return ValueFactory.newString((String)value.textValue());
        }
        if (value.isInt()) {
            return ValueFactory.newLong((Long)Long.valueOf(value.intValue()));
        }
        if (value.isLong()) {
            return ValueFactory.newLong((Long)value.longValue());
        }
        if (value.isObject()) {
            return JsonToPropertyTreeTranslator.mapSet(value);
        }
        return ValueFactory.newString((String)value.toString());
    }

    private static Value mapSet(JsonNode value) {
        PropertySet propertySet = new PropertySet();
        value.fields().forEachRemaining(field -> {
            if (((JsonNode)field.getValue()).isArray()) {
                for (JsonNode arrayNode : (JsonNode)field.getValue()) {
                    propertySet.addProperty((String)field.getKey(), JsonToPropertyTreeTranslator.resolveCoreValue(arrayNode));
                }
            } else {
                propertySet.addProperty((String)field.getKey(), JsonToPropertyTreeTranslator.resolveCoreValue((JsonNode)field.getValue()));
            }
        });
        return ValueFactory.newPropertySet((PropertySet)propertySet);
    }
}

