/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.common;

import com.enonic.xp.data.Value;
import com.enonic.xp.lib.common.ObjectToValueMapper;
import com.enonic.xp.query.filter.BooleanFilter;
import com.enonic.xp.query.filter.ExistsFilter;
import com.enonic.xp.query.filter.Filter;
import com.enonic.xp.query.filter.Filters;
import com.enonic.xp.query.filter.IdFilter;
import com.enonic.xp.query.filter.ValueFilter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonToFilterMapper {
    private static final String FIELDNAME_FIELD = "field";
    private static final String NOT_EXISTS_FILTER = "notExists";
    private static final String EXISTS_FILTER = "exists";
    private static final String BOOLEAN_FILTER = "boolean";
    private static final String HAS_VALUE_FILTER = "hasValue";
    private static final String IDS_FILTER = "ids";
    private static final String VALUES_FIELD = "values";

    public static Filters create(List<Map<String, Object>> value) {
        if (value != null && value.size() > 1) {
            return JsonToFilterMapper.wrapInBooleanMust(JsonToFilterMapper.createFilters(value));
        }
        return JsonToFilterMapper.createFilters(value);
    }

    public static Filters create(Map<String, Object> value) {
        return JsonToFilterMapper.createFilters(value);
    }

    private static Filters wrapInBooleanMust(Filters filters) {
        BooleanFilter.Builder builder = BooleanFilter.create();
        filters.forEach(arg_0 -> ((BooleanFilter.Builder)builder).must(arg_0));
        return Filters.create().add((Filter)builder.build()).build();
    }

    private static Filters createFilters(Object object) {
        if (object == null) {
            return Filters.empty();
        }
        if (object instanceof Map) {
            return JsonToFilterMapper.createFilters((Map)object);
        }
        if (object instanceof Collection) {
            return JsonToFilterMapper.createFilters((Collection)object);
        }
        throw new IllegalArgumentException("Filter not on expected format, expected Collection, got " + object.getClass().getName());
    }

    private static Filters createFilters(Collection<Object> collection) {
        Filters.Builder builder = Filters.create();
        for (Object o : collection) {
            builder.addAll((Collection)JsonToFilterMapper.createFilters(o).getList());
        }
        return builder.build();
    }

    private static Filters createFilters(Map<String, Object> filterMap) {
        if (filterMap == null) {
            return Filters.create().build();
        }
        Filters.Builder filters = Filters.create();
        for (String key : filterMap.keySet()) {
            Object filter = filterMap.get(key);
            if (filter instanceof Collection) {
                for (Object filterValue : (Collection)filter) {
                    filters.add(JsonToFilterMapper.doCreateFilter(key, filterValue));
                }
                continue;
            }
            filters.add(JsonToFilterMapper.doCreateFilter(key, filter));
        }
        return filters.build();
    }

    private static Filter doCreateFilter(String key, Object filter) {
        switch (key) {
            case "notExists": {
                return JsonToFilterMapper.createNotExistsFilter(JsonToFilterMapper.toMap(filter));
            }
            case "exists": {
                return JsonToFilterMapper.createExistsFilter(JsonToFilterMapper.toMap(filter));
            }
            case "boolean": {
                return JsonToFilterMapper.createBoolFilter(JsonToFilterMapper.toMap(filter));
            }
            case "hasValue": {
                return JsonToFilterMapper.createValueFilter(JsonToFilterMapper.toMap(filter));
            }
            case "ids": {
                return JsonToFilterMapper.createIdsFilter(JsonToFilterMapper.toMap(filter));
            }
        }
        throw new IllegalArgumentException("Unknown filter type [" + key + "]");
    }

    private static Filter createIdsFilter(Map<String, Object> idsFilter) {
        JsonToFilterMapper.requiredFields(idsFilter, VALUES_FIELD);
        return IdFilter.create().values(JsonToFilterMapper.getStringValues(idsFilter.get(VALUES_FIELD))).build();
    }

    private static Filter createExistsFilter(Map<String, Object> existsFilter) {
        JsonToFilterMapper.requiredFields(existsFilter, FIELDNAME_FIELD);
        return ((ExistsFilter.Builder)ExistsFilter.create().fieldName(existsFilter.get(FIELDNAME_FIELD).toString())).build();
    }

    private static Filter createNotExistsFilter(Map<String, Object> existsFilter) {
        JsonToFilterMapper.requiredFields(existsFilter, FIELDNAME_FIELD);
        return BooleanFilter.create().mustNot((Filter)((ExistsFilter.Builder)ExistsFilter.create().fieldName(existsFilter.get(FIELDNAME_FIELD).toString())).build()).build();
    }

    private static Filter createValueFilter(Map<String, Object> valueFilter) {
        JsonToFilterMapper.requiredFields(valueFilter, FIELDNAME_FIELD, VALUES_FIELD);
        ValueFilter.Builder builder = ((ValueFilter.Builder)ValueFilter.create().fieldName(valueFilter.get(FIELDNAME_FIELD).toString())).addAllValues(JsonToFilterMapper.getValues(valueFilter.get(VALUES_FIELD)));
        return builder.build();
    }

    private static Collection<Value> getValues(Object values) {
        ArrayList valueList = Lists.newArrayList();
        if (values instanceof Collection) {
            for (Object value : (Collection)values) {
                valueList.add(ObjectToValueMapper.map(value));
            }
        } else {
            valueList.add(ObjectToValueMapper.map(values));
        }
        return valueList;
    }

    private static Collection<String> getStringValues(Object values) {
        ArrayList valueList = Lists.newArrayList();
        if (values instanceof Collection) {
            for (Object value : (Collection)values) {
                valueList.add(value.toString());
            }
        } else {
            valueList.add(values.toString());
        }
        return valueList;
    }

    private static void requiredFields(Map<String, Object> map, String ... names) {
        for (String name : names) {
            if (map.containsKey(name)) continue;
            throw new IllegalArgumentException("Missing required field: [" + name + "] in filter");
        }
    }

    private static Filter createBoolFilter(Map<String, Object> boolFilter) {
        BooleanFilter.Builder filterBuilder = BooleanFilter.create();
        for (Filter filter : JsonToFilterMapper.createFilters(boolFilter.get("must"))) {
            filterBuilder.must(filter);
        }
        for (Filter filter : JsonToFilterMapper.createFilters(boolFilter.get("mustNot"))) {
            filterBuilder.mustNot(filter);
        }
        for (Filter filter : JsonToFilterMapper.createFilters(boolFilter.get("should"))) {
            filterBuilder.should(filter);
        }
        return filterBuilder.build();
    }

    private static Map<String, Object> toMap(Object o) {
        try {
            return (Map)o;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Filter not on expected format, expected Map, got " + o.getClass().getName());
        }
    }
}

