/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.common;

import com.enonic.xp.data.Property;
import com.enonic.xp.data.PropertySet;
import com.enonic.xp.data.PropertyTree;
import com.enonic.xp.data.Value;
import com.enonic.xp.data.ValueFactory;
import com.enonic.xp.form.Form;
import com.enonic.xp.form.FormItemPath;
import com.enonic.xp.form.FormOptionSet;
import com.enonic.xp.form.Input;
import com.enonic.xp.inputtype.InputType;
import com.enonic.xp.inputtype.InputTypeResolver;
import com.enonic.xp.inputtype.InputTypes;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.Map;

public final class FormJsonToPropertyTreeTranslator {
    private final Form form;
    private final PropertyTree propertyTree;
    private final InputTypeResolver inputTypeResolver;
    private final boolean strictMode;
    private static final String OPTION_SET_SELECTION_ARRAY_NAME = "_selected";

    public FormJsonToPropertyTreeTranslator(Form form, boolean strict) {
        this.form = form != null ? form : Form.create().build();
        this.strictMode = strict;
        this.propertyTree = new PropertyTree();
        this.inputTypeResolver = InputTypes.BUILTIN;
    }

    public PropertyTree translate(JsonNode json) {
        this.traverse(json, this.propertyTree.getRoot());
        return this.propertyTree;
    }

    private void traverse(JsonNode json, PropertySet parent) {
        Iterator fields = json.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            this.addValue(parent, (String)next.getKey(), (JsonNode)next.getValue());
        }
    }

    private void addValue(PropertySet parent, String key, JsonNode value) {
        if (value.isArray()) {
            for (JsonNode objNode : value) {
                this.addValue(parent, key, objNode);
            }
        } else if (value.isObject() && !this.hasInput(parent.getProperty(), key)) {
            PropertySet parentSet = parent.addSet(key);
            value.fields().forEachRemaining(objectValue -> this.addValue(parentSet, (String)objectValue.getKey(), (JsonNode)objectValue.getValue()));
        } else {
            this.mapValue(parent, key, value);
        }
    }

    private void mapValue(PropertySet parent, String key, JsonNode value) {
        Property parentProperty = parent.getProperty();
        Input input = this.getInput(parentProperty, key);
        if (input == null) {
            if (this.strictMode && !this.isOptionSetSelection(key, parentProperty)) {
                throw new IllegalArgumentException("No mapping defined for property " + key + " with value " + this.resolveStringValue(value));
            }
            parent.addProperty(key, this.resolveCoreValue(value));
        } else {
            InputType type = this.inputTypeResolver.resolve(input.getInputType());
            Value mappedPropertyValue = type.createValue(this.resolveCoreValue(value), input.getInputTypeConfig());
            parent.addProperty(key, mappedPropertyValue);
        }
    }

    private Value resolveCoreValue(JsonNode value) {
        if (value.isTextual()) {
            return ValueFactory.newString((String)value.textValue());
        }
        if (value.isDouble()) {
            return ValueFactory.newDouble((Double)value.doubleValue());
        }
        if (value.isInt()) {
            return ValueFactory.newLong((Long)Long.valueOf(value.intValue()));
        }
        if (value.isLong()) {
            return ValueFactory.newLong((Long)value.longValue());
        }
        if (value.isObject()) {
            PropertySet propertySet = new PropertySet();
            value.fields().forEachRemaining(field -> {
                if (((JsonNode)field.getValue()).isArray()) {
                    for (JsonNode arrayNode : (JsonNode)field.getValue()) {
                        propertySet.addProperty((String)field.getKey(), this.resolveCoreValue(arrayNode));
                    }
                } else {
                    propertySet.addProperty((String)field.getKey(), this.resolveCoreValue((JsonNode)field.getValue()));
                }
            });
            return ValueFactory.newPropertySet((PropertySet)propertySet);
        }
        return ValueFactory.newString((String)value.toString());
    }

    private String resolveStringValue(JsonNode value) {
        if (value.isTextual()) {
            return value.textValue();
        }
        return value.toString();
    }

    private FormItemPath resolveInputPath(String key, Property parentProperty) {
        if (parentProperty == null) {
            return FormItemPath.from((String)key);
        }
        FormItemPath parentPath = FormItemPath.from((String)parentProperty.getPath().resetAllIndexesTo(0).toString());
        return FormItemPath.from((Iterable)FormItemPath.from((FormItemPath)parentPath, (String)key));
    }

    private boolean hasInput(Property parentProperty, String key) {
        return Input.class.isInstance(this.form.getFormItem(this.resolveInputPath(key, parentProperty)));
    }

    private Input getInput(Property parentProperty, String key) {
        return this.form.getInput(this.resolveInputPath(key, parentProperty), true);
    }

    private boolean isOptionSetSelection(String key, Property parentProperty) {
        return OPTION_SET_SELECTION_ARRAY_NAME.equals(key) && FormOptionSet.class.isInstance(this.form.getFormItem(this.resolveInputPath(parentProperty.getName(), parentProperty.getParent().getProperty())));
    }
}

