/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.xp.lib.admin;

import com.enonic.xp.admin.tool.AdminToolDescriptorService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.server.ServerInfo;
import com.enonic.xp.server.VersionInfo;
import com.enonic.xp.web.servlet.ServletRequestHolder;
import com.enonic.xp.web.servlet.ServletRequestUrlHelper;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public final class AdminLibHelper
implements ScriptBean {
    private static final String ADMIN_APP_NAME = "com.enonic.xp.app.main";
    private static final String ADMIN_URI_PREFIX = "/admin";
    private static final String ADMIN_ASSETS_URI_PREFIX = "/admin/assets/";
    private final String version = AdminLibHelper.generateVersion();
    private Supplier<AdminToolDescriptorService> adminToolDescriptorService;

    private static String rewriteUri(String uri) {
        return ServletRequestUrlHelper.createUri((String)uri);
    }

    public String getBaseUri() {
        return AdminLibHelper.rewriteUri(ADMIN_URI_PREFIX);
    }

    public String getAssetsUri() {
        return AdminLibHelper.rewriteUri(ADMIN_ASSETS_URI_PREFIX + this.version);
    }

    public String getHomeToolUri() {
        return this.adminToolDescriptorService.get().getHomeToolUri();
    }

    public String generateAdminToolUri(String application, String adminTool) {
        return this.adminToolDescriptorService.get().generateAdminToolUri(application, adminTool);
    }

    public String getHomeAppName() {
        return ADMIN_APP_NAME;
    }

    public String getLauncherToolUrl() {
        return this.generateAdminToolUri(ADMIN_APP_NAME, "launcher");
    }

    public String getLocale() {
        HttpServletRequest req = ServletRequestHolder.getRequest();
        Locale locale = req != null ? req.getLocale() : Locale.getDefault();
        return this.resolveLanguage(locale.getLanguage().toLowerCase());
    }

    public List<String> getLocales() {
        HttpServletRequest req = ServletRequestHolder.getRequest();
        List<Locale> locales = req != null ? Collections.list(req.getLocales()) : Collections.singletonList(Locale.getDefault());
        List<String> localeList = locales.stream().map(l -> this.resolveLanguage(l.toLanguageTag().toLowerCase())).collect(Collectors.toList());
        if (localeList.isEmpty()) {
            return Collections.singletonList(this.resolveLanguage(Locale.getDefault().toLanguageTag().toLowerCase()));
        }
        return localeList;
    }

    private String resolveLanguage(String lang) {
        if (lang.equals("nn")) {
            return "no";
        }
        if (lang.equals("nb")) {
            return "no";
        }
        return lang;
    }

    private static String generateVersion() {
        VersionInfo version = VersionInfo.get();
        if (version.isSnapshot()) {
            return Long.toString(System.currentTimeMillis());
        }
        return version.getVersion();
    }

    public String getInstallation() {
        return ServerInfo.get().getName();
    }

    public String getVersion() {
        VersionInfo version = VersionInfo.get();
        return version.getVersion();
    }

    public void initialize(BeanContext context) {
        this.adminToolDescriptorService = context.getService(AdminToolDescriptorService.class);
    }
}

