/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.thymeleaf;

import com.enonic.lib.thymeleaf.ExtensionDialectImpl;
import com.enonic.lib.thymeleaf.TemplateResolverImpl;
import com.enonic.lib.thymeleaf.ThymeleafProcessor;
import com.enonic.lib.thymeleaf.ThymeleafViewFunctions;
import com.enonic.xp.portal.PortalRequestAccessor;
import com.enonic.xp.portal.view.ViewFunctionService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.standard.StandardDialect;

public final class ThymeleafService
implements ScriptBean {
    private final TemplateEngine engine = new TemplateEngine();
    private BeanContext context;

    public ThymeleafService() {
        HashSet dialects = Sets.newHashSet();
        dialects.add(new ExtensionDialectImpl());
        dialects.add(new StandardDialect());
        this.engine.setDialects(dialects);
    }

    public ThymeleafProcessor newProcessor() {
        return new ThymeleafProcessor(this.engine, this.createViewFunctions());
    }

    private ThymeleafViewFunctions createViewFunctions() {
        ThymeleafViewFunctions functions = new ThymeleafViewFunctions();
        functions.viewFunctionService = (ViewFunctionService)this.context.getService(ViewFunctionService.class).get();
        functions.portalRequest = PortalRequestAccessor.get();
        return functions;
    }

    public void initialize(BeanContext context) {
        this.context = context;
        this.engine.setTemplateResolver(new TemplateResolverImpl(this.context));
    }
}

