/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.thymeleaf;

import com.enonic.lib.thymeleaf.ThymeleafViewFunctions;
import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.resource.ResourceKey;
import com.enonic.xp.resource.ResourceProblemException;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.trace.Trace;
import com.enonic.xp.trace.Tracer;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templatemode.TemplateMode;

public final class ThymeleafProcessor {
    private final TemplateEngine engine;
    private ResourceKey view;
    private final Map<String, Object> parameters;
    private TemplateMode mode;

    public ThymeleafProcessor(TemplateEngine engine, ThymeleafViewFunctions viewFunctions) {
        this.engine = engine;
        this.parameters = Maps.newHashMap();
        this.parameters.put("portal", viewFunctions);
    }

    public void setView(ResourceKey view) {
        this.view = view;
    }

    public void setModel(ScriptValue model) {
        if (model != null) {
            this.parameters.putAll(model.getMap());
        }
    }

    public void setMode(String mode) {
        try {
            this.mode = TemplateMode.valueOf(mode.toUpperCase());
        }
        catch (Exception e) {
            this.mode = TemplateMode.HTML;
        }
    }

    public String process() {
        Trace trace = Tracer.newTrace((String)"thymeleaf.render");
        if (trace == null) {
            return this.doProcess();
        }
        return (String)Tracer.trace((Trace)trace, () -> {
            trace.put((Object)"path", (Object)this.view.getPath());
            trace.put((Object)"app", (Object)this.view.getApplicationKey().toString());
            return this.doProcess();
        });
    }

    private String doProcess() {
        try {
            Context context = new Context();
            context.setVariables(this.parameters);
            TemplateSpec spec = new TemplateSpec(this.view.toString(), this.mode);
            return this.engine.process(spec, (IContext)context);
        }
        catch (RuntimeException e) {
            throw this.handleException(e);
        }
    }

    private RuntimeException handleException(RuntimeException e) {
        if (e instanceof TemplateProcessingException) {
            return this.handleException((TemplateProcessingException)e);
        }
        return e;
    }

    private RuntimeException handleException(TemplateProcessingException e) {
        int lineNumber = e.getLine() != null ? e.getLine() : 0;
        ResourceKey resource = this.getTemplateResource(e.getTemplateName());
        Object message = e.getMessage();
        if (resource == null) {
            message = "Error in Thymeleaf template '" + e.getTemplateName() + "' : " + e.getMessage();
        }
        return ResourceProblemException.create().lineNumber(lineNumber).resource(resource).cause((Throwable)e).message((String)message, new Object[0]).build();
    }

    private ResourceKey getTemplateResource(String templateName) {
        if (templateName == null) {
            return null;
        }
        try {
            return ResourceKey.from((String)templateName);
        }
        catch (Exception e) {
            try {
                return ResourceKey.from((ApplicationKey)this.view.getApplicationKey(), (String)this.resolveTemplatePath(templateName));
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private String resolveTemplatePath(String templateName) {
        Object path = templateName;
        if (FilenameUtils.getExtension((String)templateName).isEmpty()) {
            path = (String)path + ".html";
        }
        if (templateName.startsWith("./") || templateName.startsWith("../")) {
            return Files.simplifyPath((String)(this.view.getPath() + "/../" + (String)path));
        }
        return path;
    }
}

