/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.thymeleaf;

import com.enonic.lib.thymeleaf.TemplateResourceResolver;
import com.enonic.xp.resource.Resource;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.Reader;
import org.thymeleaf.templateresource.ITemplateResource;

final class TemplateResourceImpl
implements ITemplateResource {
    private final Resource resource;
    private final TemplateResourceResolver resolver;

    TemplateResourceImpl(Resource resource, TemplateResourceResolver resolver) {
        this.resource = resource;
        this.resolver = resolver;
    }

    @Override
    public String getDescription() {
        return this.resource.getKey().toString();
    }

    @Override
    public String getBaseName() {
        return Files.getNameWithoutExtension((String)this.resource.getKey().getName());
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public Reader reader() throws IOException {
        return this.resource.openReader();
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        return this.resolver.resolve(this.resource.getKey(), relativeLocation);
    }
}

