/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.thymeleaf;

import com.enonic.lib.thymeleaf.TemplateResourceImpl;
import com.enonic.lib.thymeleaf.TemplateResourceResolver;
import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.resource.Resource;
import com.enonic.xp.resource.ResourceKey;
import com.enonic.xp.resource.ResourceService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.server.RunMode;
import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.cache.ICacheEntryValidity;
import org.thymeleaf.cache.NonCacheableCacheEntryValidity;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresource.ITemplateResource;

final class TemplateResolverImpl
extends AbstractConfigurableTemplateResolver
implements TemplateResourceResolver {
    private BeanContext context;
    private boolean disableCache;

    TemplateResolverImpl(BeanContext context) {
        this.context = context;
        this.disableCache = RunMode.get() == RunMode.DEV;
    }

    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        return this.resolve(this.context.getResourceKey(), ownerTemplate, resourceName);
    }

    @Override
    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        if (this.disableCache) {
            return new NonCacheableCacheEntryValidity();
        }
        return super.computeValidity(configuration, ownerTemplate, template, templateResolutionAttributes);
    }

    private ITemplateResource resolve(ResourceKey base, String ownerTempalte, String location) {
        ResourceKey parent = this.findParent(base, ownerTempalte);
        return this.resolve(parent, location);
    }

    private ResourceKey findParent(ResourceKey base, String ownerTempalte) {
        try {
            return ownerTempalte != null ? ResourceKey.from((String)ownerTempalte) : base;
        }
        catch (Exception e) {
            return ResourceKey.from((ApplicationKey)base.getApplicationKey(), (String)ownerTempalte);
        }
    }

    @Override
    public ITemplateResource resolve(ResourceKey base, String location) {
        ResourceKey resolved = this.resolveKey(base, location);
        Resource resource = this.resolveResource(resolved);
        return new TemplateResourceImpl(resource, this);
    }

    private ResourceKey resolveKey(ResourceKey base, String location) {
        try {
            return ResourceKey.from((String)location);
        }
        catch (Exception e) {
            return this.doResolveResource(base, location);
        }
    }

    private ResourceKey doResolveResource(ResourceKey callingTemplate, String name) {
        if (name.startsWith("/")) {
            return this.doResolveResource(callingTemplate.resolve(name));
        }
        return this.doResolveResource(callingTemplate.resolve("../" + name));
    }

    private ResourceKey doResolveResource(ResourceKey key) {
        if (key.getName().contains(".")) {
            return key;
        }
        return ResourceKey.from((String)(key.getUri() + ".html"));
    }

    private Resource resolveResource(ResourceKey key) {
        ResourceService resourceService = (ResourceService)this.context.getService(ResourceService.class).get();
        return resourceService.getResource(key);
    }
}

